/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;

public class RouteHealthCheck
extends AbstractHealthCheck {
    final Route route;

    public RouteHealthCheck(Route route) {
        this(route, "route:" + route.getId());
    }

    public RouteHealthCheck(Route route, String id) {
        super("camel", id);
        this.route = route;
    }

    @Override
    public boolean isLiveness() {
        return false;
    }

    @Override
    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        if (this.route.getId() != null) {
            CamelContext context = this.route.getCamelContext();
            ServiceStatus status = context.getRouteController().getRouteStatus(this.route.getId());
            builder.detail("route.id", this.route.getId());
            builder.detail("route.status", status.name());
            if (this.route.getRouteController() != null || this.route.isAutoStartup().booleanValue()) {
                if (status.isStarted()) {
                    builder.up();
                } else if (status.isStopped()) {
                    builder.down();
                    builder.message(String.format("Route %s has status %s", this.route.getId(), status.name()));
                }
            } else if (!this.route.isAutoStartup().booleanValue()) {
                builder.up();
            } else if (this.route.getRouteController() == null) {
                builder.unknown();
                if (this.route.getLastError() != null && this.route.getLastError().isUnhealthy()) {
                    builder.down();
                }
            }
        }
        this.doCallCheck(builder, options);
    }

    protected void doCallCheck(HealthCheckResultBuilder builder, Map<String, Object> options) {
    }
}

