/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.processor.WrapProcessor;
import org.apache.camel.reifier.AbstractPolicyReifier;
import org.apache.camel.spi.Policy;
import org.apache.camel.util.ObjectHelper;

public class TransactedReifier
extends AbstractPolicyReifier<TransactedDefinition> {
    public TransactedReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (TransactedDefinition)definition);
    }

    public TransactedReifier(CamelContext camelContext, ProcessorDefinition<?> definition) {
        super(camelContext, (TransactedDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Policy policy = this.resolvePolicy();
        ObjectHelper.notNull(policy, "policy", this);
        policy.beforeWrap(this.route, this.definition);
        Processor childProcessor = this.createChildProcessor(true);
        Processor target = policy.wrap(this.route, childProcessor);
        if (!(target instanceof Service)) {
            target = new WrapProcessor(target, childProcessor);
        }
        return target;
    }

    public Policy resolvePolicy() {
        return this.resolvePolicy(((TransactedDefinition)this.definition).getPolicy(), ((TransactedDefinition)this.definition).getRef(), ((TransactedDefinition)this.definition).getType());
    }
}

