/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.errorhandler.DeadLetterChannelDefinition;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.NoErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.RefErrorHandlerDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.processor.errorhandler.ExceptionPolicy;
import org.apache.camel.processor.errorhandler.ExceptionPolicyKey;
import org.apache.camel.processor.errorhandler.RedeliveryErrorHandler;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.errorhandler.DeadLetterChannelReifier;
import org.apache.camel.reifier.errorhandler.DefaultErrorHandlerReifier;
import org.apache.camel.reifier.errorhandler.ErrorHandlerRefReifier;
import org.apache.camel.reifier.errorhandler.NoErrorHandlerReifier;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.spi.Language;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public abstract class ErrorHandlerReifier<T extends ErrorHandlerFactory>
extends AbstractReifier {
    private static final Map<Class<?>, BiFunction<Route, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>>> ERROR_HANDLERS = new HashMap(0);
    protected T definition;

    protected ErrorHandlerReifier(Route route, T definition) {
        super(route);
        this.definition = definition;
    }

    public static void registerReifier(Class<?> errorHandlerClass, BiFunction<Route, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>> creator) {
        ERROR_HANDLERS.put(errorHandlerClass, creator);
    }

    public static ErrorHandlerReifier<? extends ErrorHandlerFactory> reifier(Route route, ErrorHandlerFactory definition) {
        BiFunction<Route, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>> reifier;
        ErrorHandlerReifier<ErrorHandlerFactory> answer = null;
        if (!ERROR_HANDLERS.isEmpty() && (reifier = ERROR_HANDLERS.get(definition.getClass())) != null) {
            answer = reifier.apply(route, definition);
        }
        if (answer == null) {
            answer = ErrorHandlerReifier.coreReifier(route, definition);
        }
        if (answer == null) {
            throw new IllegalStateException("Unsupported definition: " + definition);
        }
        return answer;
    }

    private static ErrorHandlerReifier<? extends ErrorHandlerFactory> coreReifier(Route route, ErrorHandlerFactory definition) {
        if (definition instanceof DeadLetterChannelDefinition) {
            return new DeadLetterChannelReifier(route, (DeadLetterChannelDefinition)definition);
        }
        if (definition instanceof DefaultErrorHandlerDefinition) {
            return new DefaultErrorHandlerReifier(route, (DefaultErrorHandlerDefinition)definition);
        }
        if (definition instanceof NoErrorHandlerDefinition) {
            return new NoErrorHandlerReifier(route, definition);
        }
        if (definition instanceof RefErrorHandlerDefinition) {
            return new ErrorHandlerRefReifier(route, definition);
        }
        return null;
    }

    public ExceptionPolicy createExceptionPolicy(OnExceptionDefinition def) {
        Predicate retryWhile;
        Predicate continued;
        Predicate handled = def.getHandledPolicy();
        if (handled == null && def.getHandled() != null) {
            handled = this.createPredicate(def.getHandled());
        }
        if ((continued = def.getContinuedPolicy()) == null && def.getContinued() != null) {
            continued = this.createPredicate(def.getContinued());
        }
        if ((retryWhile = def.getRetryWhilePolicy()) == null && def.getRetryWhile() != null) {
            retryWhile = this.createPredicate(def.getRetryWhile());
        }
        Processor onRedelivery = this.getProcessor(def.getOnRedelivery(), def.getOnRedeliveryRef());
        Processor onExceptionOccurred = this.getProcessor(def.getOnExceptionOccurred(), def.getOnExceptionOccurredRef());
        return new ExceptionPolicy(def.getId(), CamelContextHelper.getRouteId(def), this.parseBoolean(def.getUseOriginalMessage(), false), this.parseBoolean(def.getUseOriginalBody(), false), ObjectHelper.isNotEmpty(def.getOutputs()), handled, continued, retryWhile, onRedelivery, onExceptionOccurred, def.getRedeliveryPolicyRef(), ErrorHandlerReifier.createRedeliveryPolicyOptions(def.getRedeliveryPolicyType()), def.getExceptions());
    }

    public static RedeliveryPolicy createRedeliveryPolicy(RedeliveryPolicyDefinition definition, CamelContext context) {
        Map<ExceptionPolicy.RedeliveryOption, String> options = ErrorHandlerReifier.createRedeliveryPolicyOptions(definition);
        return ErrorHandlerReifier.createRedeliveryPolicy(options, context, null);
    }

    private static RedeliveryPolicy createRedeliveryPolicy(Map<ExceptionPolicy.RedeliveryOption, String> definition, CamelContext context, RedeliveryPolicy parentPolicy) {
        RedeliveryPolicy answer = parentPolicy != null ? parentPolicy.copy() : new RedeliveryPolicy();
        try {
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.maximumRedeliveries) != null) {
                answer.setMaximumRedeliveries(CamelContextHelper.parseInteger(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.maximumRedeliveries)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.redeliveryDelay) != null) {
                answer.setRedeliveryDelay(CamelContextHelper.parseLong(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.redeliveryDelay)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.asyncDelayedRedelivery) != null) {
                answer.setAsyncDelayedRedelivery(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.asyncDelayedRedelivery)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.retriesExhaustedLogLevel) != null) {
                answer.setRetriesExhaustedLogLevel(CamelContextHelper.parse(context, LoggingLevel.class, definition.get((Object)ExceptionPolicy.RedeliveryOption.retriesExhaustedLogLevel)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.retryAttemptedLogLevel) != null) {
                answer.setRetryAttemptedLogLevel(CamelContextHelper.parse(context, LoggingLevel.class, definition.get((Object)ExceptionPolicy.RedeliveryOption.retryAttemptedLogLevel)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.retryAttemptedLogInterval) != null) {
                answer.setRetryAttemptedLogInterval(CamelContextHelper.parseInteger(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.retryAttemptedLogInterval)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.backOffMultiplier) != null) {
                answer.setBackOffMultiplier(CamelContextHelper.parseDouble(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.backOffMultiplier)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.useExponentialBackOff) != null) {
                answer.setUseExponentialBackOff(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.useExponentialBackOff)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.collisionAvoidanceFactor) != null) {
                answer.setCollisionAvoidanceFactor(CamelContextHelper.parseDouble(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.collisionAvoidanceFactor)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.useCollisionAvoidance) != null) {
                answer.setUseCollisionAvoidance(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.useCollisionAvoidance)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.maximumRedeliveryDelay) != null) {
                answer.setMaximumRedeliveryDelay(CamelContextHelper.parseLong(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.maximumRedeliveryDelay)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.logStackTrace) != null) {
                answer.setLogStackTrace(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.logStackTrace)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.logRetryStackTrace) != null) {
                answer.setLogRetryStackTrace(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.logRetryStackTrace)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.logHandled) != null) {
                answer.setLogHandled(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.logHandled)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.logNewException) != null) {
                answer.setLogNewException(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.logNewException)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.logContinued) != null) {
                answer.setLogContinued(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.logContinued)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.logRetryAttempted) != null) {
                answer.setLogRetryAttempted(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.logRetryAttempted)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.logExhausted) != null) {
                answer.setLogExhausted(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.logExhausted)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.logExhaustedMessageHistory) != null) {
                answer.setLogExhaustedMessageHistory(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.logExhaustedMessageHistory)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.logExhaustedMessageBody) != null) {
                answer.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.logExhaustedMessageBody)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.disableRedelivery) != null && CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.disableRedelivery)).booleanValue()) {
                answer.setMaximumRedeliveries(0);
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.delayPattern) != null) {
                answer.setDelayPattern(CamelContextHelper.parseText(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.delayPattern)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.allowRedeliveryWhileStopping) != null) {
                answer.setAllowRedeliveryWhileStopping(CamelContextHelper.parseBoolean(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.allowRedeliveryWhileStopping)));
            }
            if (definition.get((Object)ExceptionPolicy.RedeliveryOption.exchangeFormatterRef) != null) {
                answer.setExchangeFormatterRef(CamelContextHelper.parseText(context, definition.get((Object)ExceptionPolicy.RedeliveryOption.exchangeFormatterRef)));
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    private static Map<ExceptionPolicy.RedeliveryOption, String> createRedeliveryPolicyOptions(RedeliveryPolicyDefinition definition) {
        if (definition == null) {
            return null;
        }
        HashMap<ExceptionPolicy.RedeliveryOption, String> policy = new HashMap<ExceptionPolicy.RedeliveryOption, String>();
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.maximumRedeliveries, definition.getMaximumRedeliveries());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.redeliveryDelay, definition.getRedeliveryDelay(), "1000");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.asyncDelayedRedelivery, definition.getAsyncDelayedRedelivery());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.backOffMultiplier, definition.getBackOffMultiplier(), "2");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.useExponentialBackOff, definition.getUseExponentialBackOff());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.collisionAvoidanceFactor, definition.getCollisionAvoidanceFactor(), "0.15");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.useCollisionAvoidance, definition.getUseCollisionAvoidance());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.maximumRedeliveryDelay, definition.getMaximumRedeliveryDelay(), "60000");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retriesExhaustedLogLevel, definition.getRetriesExhaustedLogLevel(), "ERROR");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retryAttemptedLogLevel, definition.getRetryAttemptedLogLevel(), "DEBUG");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retryAttemptedLogInterval, definition.getRetryAttemptedLogInterval(), "1");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logRetryAttempted, definition.getLogRetryAttempted(), "true");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logStackTrace, definition.getLogStackTrace(), "true");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logRetryStackTrace, definition.getLogRetryStackTrace());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logHandled, definition.getLogHandled());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logNewException, definition.getLogNewException(), "true");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logContinued, definition.getLogContinued());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhausted, definition.getLogExhausted(), "true");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhaustedMessageHistory, definition.getLogExhaustedMessageHistory());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhaustedMessageBody, definition.getLogExhaustedMessageBody());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.disableRedelivery, definition.getDisableRedelivery());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.delayPattern, definition.getDelayPattern());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.allowRedeliveryWhileStopping, definition.getAllowRedeliveryWhileStopping(), "true");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.exchangeFormatterRef, definition.getExchangeFormatterRef());
        return policy;
    }

    private static void setOption(Map<ExceptionPolicy.RedeliveryOption, String> policy, ExceptionPolicy.RedeliveryOption option, Object value) {
        ErrorHandlerReifier.setOption(policy, option, value, null);
    }

    private static void setOption(Map<ExceptionPolicy.RedeliveryOption, String> policy, ExceptionPolicy.RedeliveryOption option, Object value, Object defaultValue) {
        if (value != null) {
            policy.put(option, value.toString());
        } else if (defaultValue != null) {
            policy.put(option, defaultValue.toString());
        }
    }

    public void addExceptionPolicy(ErrorHandlerSupport handlerSupport, OnExceptionDefinition exceptionType) {
        Processor errorHandler = this.route.getOnException(exceptionType.getId());
        handlerSupport.addErrorHandler(errorHandler);
        if (ObjectHelper.isNotEmpty(exceptionType.getExceptions())) {
            List<Class<Throwable>> list = this.createExceptionClasses(exceptionType);
            for (Class<Throwable> clazz : list) {
                String routeId = null;
                if (exceptionType.isRouteScoped()) {
                    routeId = this.route.getRouteId();
                }
                ExpressionDefinition when = exceptionType.getOnWhen() != null ? exceptionType.getOnWhen().getExpression() : null;
                ExceptionPolicyKey key = new ExceptionPolicyKey(routeId, clazz, when);
                ExceptionPolicy policy = this.createExceptionPolicy(exceptionType);
                handlerSupport.addExceptionPolicy(key, policy);
            }
        }
    }

    protected List<Class<? extends Throwable>> createExceptionClasses(OnExceptionDefinition exceptionType) {
        List<String> list = exceptionType.getExceptions();
        ArrayList<Class<? extends Throwable>> answer = new ArrayList<Class<? extends Throwable>>(list.size());
        for (String name : list) {
            try {
                Class<Throwable> type = this.camelContext.getClassResolver().resolveMandatoryClass(name, Throwable.class);
                answer.add(type);
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
        return answer;
    }

    public abstract Processor createErrorHandler(Processor var1) throws Exception;

    public void configure(ErrorHandler handler) {
        if (handler instanceof ErrorHandlerSupport) {
            ErrorHandlerSupport handlerSupport = (ErrorHandlerSupport)handler;
            for (NamedNode exception : this.route.getErrorHandlers((ErrorHandlerFactory)this.definition)) {
                this.addExceptionPolicy(handlerSupport, (OnExceptionDefinition)exception);
            }
        }
        if (handler instanceof RedeliveryErrorHandler) {
            boolean original;
            boolean bl = original = ((RedeliveryErrorHandler)handler).isUseOriginalMessagePolicy() || ((RedeliveryErrorHandler)handler).isUseOriginalBodyPolicy();
            if (original) {
                this.route.setAllowUseOriginalMessage(true);
            }
        }
    }

    public static RedeliveryPolicy createRedeliveryPolicy(RedeliveryPolicyDefinition definition, CamelContext context, RedeliveryPolicy parentPolicy) {
        RedeliveryPolicy answer = parentPolicy != null ? parentPolicy.copy() : new RedeliveryPolicy();
        try {
            Duration duration;
            if (definition.getMaximumRedeliveries() != null) {
                answer.setMaximumRedeliveries(CamelContextHelper.parseInteger(context, definition.getMaximumRedeliveries()));
            }
            if (definition.getRedeliveryDelay() != null) {
                duration = CamelContextHelper.parseDuration(context, definition.getRedeliveryDelay());
                answer.setRedeliveryDelay(duration.toMillis());
            }
            if (definition.getAsyncDelayedRedelivery() != null) {
                answer.setAsyncDelayedRedelivery(CamelContextHelper.parseBoolean(context, definition.getAsyncDelayedRedelivery()));
            }
            if (definition.getRetriesExhaustedLogLevel() != null) {
                answer.setRetriesExhaustedLogLevel(CamelContextHelper.parse(context, LoggingLevel.class, definition.getRetriesExhaustedLogLevel()));
            }
            if (definition.getRetryAttemptedLogLevel() != null) {
                answer.setRetryAttemptedLogLevel(CamelContextHelper.parse(context, LoggingLevel.class, definition.getRetryAttemptedLogLevel()));
            }
            if (definition.getRetryAttemptedLogInterval() != null) {
                answer.setRetryAttemptedLogInterval(CamelContextHelper.parseInteger(context, definition.getRetryAttemptedLogInterval()));
            }
            if (definition.getBackOffMultiplier() != null) {
                answer.setBackOffMultiplier(CamelContextHelper.parseDouble(context, definition.getBackOffMultiplier()));
            }
            if (definition.getUseExponentialBackOff() != null) {
                answer.setUseExponentialBackOff(CamelContextHelper.parseBoolean(context, definition.getUseExponentialBackOff()));
            }
            if (definition.getCollisionAvoidanceFactor() != null) {
                answer.setCollisionAvoidanceFactor(CamelContextHelper.parseDouble(context, definition.getCollisionAvoidanceFactor()));
            }
            if (definition.getUseCollisionAvoidance() != null) {
                answer.setUseCollisionAvoidance(CamelContextHelper.parseBoolean(context, definition.getUseCollisionAvoidance()));
            }
            if (definition.getMaximumRedeliveryDelay() != null) {
                duration = CamelContextHelper.parseDuration(context, definition.getMaximumRedeliveryDelay());
                answer.setMaximumRedeliveryDelay(duration.toMillis());
            }
            if (definition.getLogStackTrace() != null) {
                answer.setLogStackTrace(CamelContextHelper.parseBoolean(context, definition.getLogStackTrace()));
            }
            if (definition.getLogRetryStackTrace() != null) {
                answer.setLogRetryStackTrace(CamelContextHelper.parseBoolean(context, definition.getLogRetryStackTrace()));
            }
            if (definition.getLogHandled() != null) {
                answer.setLogHandled(CamelContextHelper.parseBoolean(context, definition.getLogHandled()));
            }
            if (definition.getLogNewException() != null) {
                answer.setLogNewException(CamelContextHelper.parseBoolean(context, definition.getLogNewException()));
            }
            if (definition.getLogContinued() != null) {
                answer.setLogContinued(CamelContextHelper.parseBoolean(context, definition.getLogContinued()));
            }
            if (definition.getLogRetryAttempted() != null) {
                answer.setLogRetryAttempted(CamelContextHelper.parseBoolean(context, definition.getLogRetryAttempted()));
            }
            if (definition.getLogExhausted() != null) {
                answer.setLogExhausted(CamelContextHelper.parseBoolean(context, definition.getLogExhausted()));
            }
            if (definition.getLogExhaustedMessageHistory() != null) {
                answer.setLogExhaustedMessageHistory(CamelContextHelper.parseBoolean(context, definition.getLogExhaustedMessageHistory()));
            }
            if (definition.getLogExhaustedMessageBody() != null) {
                answer.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean(context, definition.getLogExhaustedMessageBody()));
            }
            if (definition.getDisableRedelivery() != null && CamelContextHelper.parseBoolean(context, definition.getDisableRedelivery()).booleanValue()) {
                answer.setMaximumRedeliveries(0);
            }
            if (definition.getDelayPattern() != null) {
                answer.setDelayPattern(CamelContextHelper.parseText(context, definition.getDelayPattern()));
            }
            if (definition.getAllowRedeliveryWhileStopping() != null) {
                answer.setAllowRedeliveryWhileStopping(CamelContextHelper.parseBoolean(context, definition.getAllowRedeliveryWhileStopping()));
            }
            if (definition.getExchangeFormatterRef() != null) {
                answer.setExchangeFormatterRef(CamelContextHelper.parseText(context, definition.getExchangeFormatterRef()));
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    protected Predicate getPredicate(Predicate pred, String ref) {
        if (pred == null && ref != null) {
            Language bean = this.camelContext.resolveLanguage("bean");
            pred = bean.createPredicate(ref);
        }
        return pred;
    }

    protected <T> T getBean(Class<T> clazz, T bean, String ref) {
        if (bean == null && ref != null) {
            bean = this.lookupByNameAndType(ref, clazz);
        }
        return bean;
    }

    protected Processor getProcessor(Processor processor, String ref) {
        if (processor == null) {
            processor = this.getBean(Processor.class, null, ref);
        }
        if (processor != null) {
            processor = this.camelContext.adapt(ExtendedCamelContext.class).getInternalProcessorFactory().addUnitOfWorkProcessorAdvice(this.camelContext, processor, this.route);
        }
        return processor;
    }
}

