/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;

public class TimeoutMapEntry<K, V>
implements Comparable<Object>,
Map.Entry<K, V> {
    private K key;
    private V value;
    private long timeout;
    private long expireTime;

    public TimeoutMapEntry(K id, V handler, long timeout) {
        this.key = id;
        this.value = handler;
        this.timeout = timeout;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        V oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public int compareTo(Object that) {
        if (this == that) {
            return 0;
        }
        if (that instanceof TimeoutMapEntry) {
            return this.compareTo((TimeoutMapEntry)that);
        }
        return 1;
    }

    @Override
    public int compareTo(TimeoutMapEntry<K, V> that) {
        long diff = this.expireTime - that.expireTime;
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return this.key.hashCode() - that.key.hashCode();
    }

    public String toString() {
        return this.key + " (times out after " + this.timeout + " millis)";
    }
}

