/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet;

import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Suspendable;
import org.apache.camel.component.kamelet.KameletComponent;
import org.apache.camel.component.kamelet.KameletEndpoint;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.support.DefaultConsumer;

final class KameletConsumer
extends DefaultConsumer
implements ShutdownAware,
Suspendable {
    private final InflightRepository inflight;
    private final KameletComponent component;
    private final String key;

    public KameletConsumer(KameletEndpoint endpoint, Processor processor, String key) {
        super(endpoint, processor);
        this.component = endpoint.getComponent();
        this.key = key;
        this.inflight = endpoint.getCamelContext().getInflightRepository();
    }

    @Override
    public KameletEndpoint getEndpoint() {
        return (KameletEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.component.addConsumer(this.key, this);
    }

    @Override
    protected void doStop() throws Exception {
        this.component.removeConsumer(this.key, this);
        super.doStop();
    }

    @Override
    protected void doSuspend() throws Exception {
        this.component.removeConsumer(this.key, this);
    }

    @Override
    protected void doResume() throws Exception {
        this.component.addConsumer(this.key, this);
    }

    @Override
    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    @Override
    public int getPendingExchangesSize() {
        return this.inflight.size(this.getRouteId());
    }

    @Override
    public void prepareShutdown(boolean suspendOnly, boolean forced) {
    }
}

