/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="routingSlip")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoutingSlipDefinition<Type extends ProcessorDefinition<Type>>
extends ExpressionNode {
    public static final String DEFAULT_DELIMITER = ",";
    @XmlAttribute
    @Metadata(defaultValue=",")
    private String uriDelimiter;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreInvalidEndpoints;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String cacheSize;

    public RoutingSlipDefinition() {
        if (this.uriDelimiter == null) {
            this.setUriDelimiter(DEFAULT_DELIMITER);
        } else {
            this.setUriDelimiter(this.uriDelimiter);
        }
    }

    public RoutingSlipDefinition(String headerName) {
        this(headerName, DEFAULT_DELIMITER);
    }

    public RoutingSlipDefinition(String headerName, String uriDelimiter) {
        super(new HeaderExpression(headerName));
        this.setUriDelimiter(uriDelimiter);
    }

    public RoutingSlipDefinition(Expression expression, String uriDelimiter) {
        super(expression);
        this.setUriDelimiter(uriDelimiter);
    }

    public RoutingSlipDefinition(Expression expression) {
        this(expression, DEFAULT_DELIMITER);
    }

    public String toString() {
        return "RoutingSlip[" + this.getExpression() + "]";
    }

    @Override
    public String getShortName() {
        return "routingSlip";
    }

    @Override
    public String getLabel() {
        return "routingSlip[" + this.getExpression() + "]";
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return Collections.emptyList();
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public void setUriDelimiter(String uriDelimiter) {
        this.uriDelimiter = uriDelimiter;
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setIgnoreInvalidEndpoints(String ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public String getIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public String getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(String cacheSize) {
        this.cacheSize = cacheSize;
    }

    public Type end() {
        return (Type)super.end();
    }

    public RoutingSlipDefinition<Type> ignoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints(true);
    }

    public RoutingSlipDefinition<Type> ignoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        return this.ignoreInvalidEndpoints(Boolean.toString(ignoreInvalidEndpoints));
    }

    public RoutingSlipDefinition<Type> ignoreInvalidEndpoints(String ignoreInvalidEndpoints) {
        this.setIgnoreInvalidEndpoints(ignoreInvalidEndpoints);
        return this;
    }

    public RoutingSlipDefinition<Type> uriDelimiter(String uriDelimiter) {
        this.setUriDelimiter(uriDelimiter);
        return this;
    }

    public RoutingSlipDefinition<Type> cacheSize(int cacheSize) {
        return this.cacheSize(Integer.toString(cacheSize));
    }

    public RoutingSlipDefinition<Type> cacheSize(String cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }
}

