/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.language;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.TokenizerExpression;
import org.apache.camel.reifier.language.ExpressionReifier;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;

public class TokenizerExpressionReifier
extends ExpressionReifier<TokenizerExpression> {
    public TokenizerExpressionReifier(CamelContext camelContext, ExpressionDefinition definition) {
        super(camelContext, (TokenizerExpression)definition);
    }

    protected Object[] createProperties() {
        Object[] properties = new Object[10];
        String token = ((TokenizerExpression)this.definition).getToken();
        if (token.startsWith("\\n")) {
            token = '\n' + token.substring(2);
        }
        properties[0] = this.parseString(token);
        properties[1] = this.parseString(((TokenizerExpression)this.definition).getEndToken());
        properties[2] = this.parseString(((TokenizerExpression)this.definition).getInheritNamespaceTagName());
        properties[3] = this.parseString(((TokenizerExpression)this.definition).getHeaderName());
        properties[4] = this.parseString(((TokenizerExpression)this.definition).getGroupDelimiter());
        properties[5] = this.parseBoolean(((TokenizerExpression)this.definition).getRegex());
        properties[6] = this.parseBoolean(((TokenizerExpression)this.definition).getXml());
        properties[7] = this.parseBoolean(((TokenizerExpression)this.definition).getIncludeTokens());
        properties[8] = this.parseString(((TokenizerExpression)this.definition).getGroup());
        properties[9] = this.parseBoolean(((TokenizerExpression)this.definition).getSkipFirst());
        return properties;
    }

    @Override
    public Predicate createPredicate() {
        Expression exp = this.createExpression();
        return ExpressionToPredicateAdapter.toPredicate(exp);
    }

    @Override
    protected Expression createExpression(Language language, String exp) {
        return language.createExpression(exp, this.createProperties());
    }

    @Override
    protected Predicate createPredicate(Language language, String exp) {
        return language.createPredicate(exp, this.createProperties());
    }
}

