/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kestrel;

import net.spy.memcached.MemcachedClient;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kestrel.KestrelEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class KestrelProducer
extends DefaultProducer {
    private final KestrelEndpoint endpoint;
    private final MemcachedClient memcachedClient;

    public KestrelProducer(KestrelEndpoint endpoint, MemcachedClient memcachedClient) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.memcachedClient = memcachedClient;
    }

    public void process(Exchange exchange) throws Exception {
        String msg = (String)exchange.getIn().getBody(String.class);
        String queue = this.endpoint.getQueue();
        if (msg != null) {
            try {
                this.log.debug("Sending to: {} message: {}", (Object)queue, (Object)msg);
                this.memcachedClient.set(queue, 0, msg);
            }
            catch (Exception e) {
                throw new CamelExchangeException("Error sending to: " + queue, exchange, (Throwable)e);
            }
        } else {
            this.log.debug("No message body to send to: {}", (Object)queue);
        }
    }
}

