/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.knative.KnativeConfiguration;
import org.apache.camel.component.knative.KnativeEndpoint;
import org.apache.camel.component.knative.spi.Knative;
import org.apache.camel.component.knative.spi.KnativeConsumerFactory;
import org.apache.camel.component.knative.spi.KnativeEnvironment;
import org.apache.camel.component.knative.spi.KnativeProducerFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="knative")
public class KnativeComponent
extends DefaultComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnativeComponent.class);
    @Metadata
    private KnativeConfiguration configuration;
    @Metadata
    private String environmentPath;
    @Metadata(defaultValue="http")
    private Knative.Protocol protocol = Knative.Protocol.http;
    @Metadata
    private KnativeProducerFactory producerFactory;
    @Metadata
    private KnativeConsumerFactory consumerFactory;
    private boolean managedProducer;
    private boolean managedConsumer;

    public KnativeComponent() {
        this(null);
    }

    public KnativeComponent(CamelContext context) {
        super(context);
        this.configuration = new KnativeConfiguration();
        this.configuration.setTransportOptions(new HashMap<String, Object>());
    }

    public KnativeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KnativeConfiguration configuration) {
        this.configuration = ObjectHelper.notNull(configuration, "configuration");
    }

    public String getEnvironmentPath() {
        return this.environmentPath;
    }

    public void setEnvironmentPath(String environmentPath) {
        this.environmentPath = environmentPath;
    }

    public KnativeEnvironment getEnvironment() {
        return this.configuration.getEnvironment();
    }

    public void setEnvironment(KnativeEnvironment environment) {
        this.configuration.setEnvironment(environment);
    }

    public String getCloudEventsSpecVersion() {
        return this.configuration.getCloudEventsSpecVersion();
    }

    public void setCloudEventsSpecVersion(String cloudEventSpecVersion) {
        this.configuration.setCloudEventsSpecVersion(cloudEventSpecVersion);
    }

    public Knative.Protocol getProtocol() {
        return this.protocol;
    }

    public KnativeComponent setProtocol(Knative.Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public KnativeProducerFactory getProducerFactory() {
        return this.producerFactory;
    }

    public void setProducerFactory(KnativeProducerFactory producerFactory) {
        this.producerFactory = producerFactory;
    }

    public KnativeConsumerFactory getConsumerFactory() {
        return this.consumerFactory;
    }

    public void setConsumerFactory(KnativeConsumerFactory consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    public Map<String, Object> getTransportOptions() {
        return this.configuration.getTransportOptions();
    }

    public void setTransportOptions(Map<String, Object> transportOptions) {
        this.configuration.setTransportOptions(transportOptions);
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.setUpProducerFactory();
        this.setUpConsumerFactory();
        if (this.producerFactory != null && this.managedProducer) {
            ServiceHelper.initService((Object)this.producerFactory);
        }
        if (this.consumerFactory != null && this.managedConsumer) {
            ServiceHelper.initService((Object)this.consumerFactory);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.producerFactory != null && this.managedProducer) {
            ServiceHelper.startService((Object)this.producerFactory);
        }
        if (this.consumerFactory != null && this.managedConsumer) {
            ServiceHelper.startService((Object)this.consumerFactory);
        }
        if (this.producerFactory == null && this.consumerFactory == null) {
            throw new IllegalStateException("No producer or consumer factory has been configured");
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.producerFactory != null && this.managedProducer) {
            ServiceHelper.stopService((Object)this.producerFactory);
        }
        if (this.consumerFactory != null && this.managedConsumer) {
            ServiceHelper.stopService((Object)this.consumerFactory);
        }
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty(remaining)) {
            throw new IllegalArgumentException("Expecting URI in the form of: 'knative:type/name', got '" + uri + "'");
        }
        String type = ObjectHelper.supplyIfEmpty(StringHelper.before(remaining, "/"), () -> remaining);
        String name = StringHelper.after(remaining, "/");
        KnativeConfiguration conf = this.getKnativeConfiguration();
        conf.getFilters().putAll(PropertiesHelper.extractProperties(parameters, "filter.", true));
        conf.getCeOverride().putAll(PropertiesHelper.extractProperties(parameters, "ce.override.", true));
        conf.getTransportOptions().putAll(PropertiesHelper.extractProperties(parameters, "transport.", true));
        KnativeEndpoint endpoint = new KnativeEndpoint(uri, this, Knative.Type.valueOf(type), name, conf);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    private KnativeConfiguration getKnativeConfiguration() throws Exception {
        String envConfig = System.getenv("CAMEL_KNATIVE_CONFIGURATION");
        KnativeConfiguration conf = this.configuration.copy();
        if (conf.getTransportOptions() == null) {
            conf.setTransportOptions(new HashMap<String, Object>());
        }
        if (conf.getFilters() == null) {
            conf.setFilters(new HashMap<String, String>());
        }
        if (conf.getCeOverride() == null) {
            conf.setCeOverride(new HashMap<String, String>());
        }
        if (conf.getEnvironment() == null) {
            KnativeEnvironment env = this.environmentPath != null ? KnativeEnvironment.mandatoryLoadFromResource(this.getCamelContext(), this.environmentPath) : (envConfig != null ? (envConfig.startsWith("file:") || envConfig.startsWith("classpath:") ? KnativeEnvironment.mandatoryLoadFromResource(this.getCamelContext(), envConfig) : KnativeEnvironment.mandatoryLoadFromSerializedString(envConfig)) : CamelContextHelper.findSingleByType(this.getCamelContext(), KnativeEnvironment.class));
            if (env == null) {
                throw new IllegalStateException("Cannot load Knative configuration from file or env variable");
            }
            conf.setEnvironment(env);
        }
        return conf;
    }

    private void setUpProducerFactory() throws Exception {
        if (this.producerFactory == null) {
            this.producerFactory = CamelContextHelper.lookup(this.getCamelContext(), this.protocol.name(), KnativeProducerFactory.class);
            if (this.producerFactory == null) {
                this.producerFactory = this.getCamelContext().adapt(ExtendedCamelContext.class).getBootstrapFactoryFinder("META-INF/services/org/apache/camel/knative/transport/").newInstance(this.protocol.name() + "-producer", KnativeProducerFactory.class).orElse(null);
                if (this.producerFactory == null) {
                    return;
                }
                if (this.configuration.getTransportOptions() != null) {
                    this.setProperties(this.producerFactory, new HashMap<String, Object>(this.configuration.getTransportOptions()));
                }
                this.managedProducer = true;
                CamelContextAware.trySetCamelContext(this.producerFactory, this.getCamelContext());
            }
            LOGGER.info("Using Knative producer factory: {} for protocol: {}", (Object)this.producerFactory, (Object)this.protocol.name());
        }
    }

    private void setUpConsumerFactory() throws Exception {
        if (this.consumerFactory == null) {
            this.consumerFactory = CamelContextHelper.lookup(this.getCamelContext(), this.protocol.name(), KnativeConsumerFactory.class);
            if (this.consumerFactory == null) {
                this.consumerFactory = this.getCamelContext().adapt(ExtendedCamelContext.class).getBootstrapFactoryFinder("META-INF/services/org/apache/camel/knative/transport/").newInstance(this.protocol.name() + "-consumer", KnativeConsumerFactory.class).orElse(null);
                if (this.consumerFactory == null) {
                    return;
                }
                if (this.configuration.getTransportOptions() != null) {
                    this.setProperties(this.consumerFactory, new HashMap<String, Object>(this.configuration.getTransportOptions()));
                }
                this.managedConsumer = true;
                CamelContextAware.trySetCamelContext(this.consumerFactory, this.getCamelContext());
            }
            LOGGER.info("Using Knative consumer factory: {} for protocol: {}", (Object)this.consumerFactory, (Object)this.protocol.name());
        }
    }
}

