/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.knative.KnativeComponent;
import org.apache.camel.component.knative.KnativeConfiguration;
import org.apache.camel.component.knative.spi.KnativeConsumerFactory;
import org.apache.camel.component.knative.spi.KnativeEnvironment;
import org.apache.camel.component.knative.spi.KnativeProducerFactory;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class KnativeComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private KnativeConfiguration getOrCreateConfiguration(KnativeComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new KnativeConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        KnativeComponent target = (KnativeComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "apiversion": 
            case "apiVersion": {
                this.getOrCreateConfiguration(target).setApiVersion(KnativeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(KnativeComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(KnativeComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "ceoverride": 
            case "ceOverride": {
                this.getOrCreateConfiguration(target).setCeOverride(KnativeComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "cloudeventsspecversion": 
            case "cloudEventsSpecVersion": {
                this.getOrCreateConfiguration(target).setCloudEventsSpecVersion(KnativeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "cloudeventstype": 
            case "cloudEventsType": {
                this.getOrCreateConfiguration(target).setCloudEventsType(KnativeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(KnativeComponentConfigurer.property(camelContext, KnativeConfiguration.class, value));
                return true;
            }
            case "consumerfactory": 
            case "consumerFactory": {
                target.setConsumerFactory(KnativeComponentConfigurer.property(camelContext, KnativeConsumerFactory.class, value));
                return true;
            }
            case "environment": {
                this.getOrCreateConfiguration(target).setEnvironment(KnativeComponentConfigurer.property(camelContext, KnativeEnvironment.class, value));
                return true;
            }
            case "environmentpath": 
            case "environmentPath": {
                target.setEnvironmentPath(KnativeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "filters": {
                this.getOrCreateConfiguration(target).setFilters(KnativeComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "kind": {
                this.getOrCreateConfiguration(target).setKind(KnativeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(KnativeComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "name": {
                this.getOrCreateConfiguration(target).setName(KnativeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "producerfactory": 
            case "producerFactory": {
                target.setProducerFactory(KnativeComponentConfigurer.property(camelContext, KnativeProducerFactory.class, value));
                return true;
            }
            case "reply": {
                this.getOrCreateConfiguration(target).setReply(KnativeComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "replywithcloudevent": 
            case "replyWithCloudEvent": {
                this.getOrCreateConfiguration(target).setReplyWithCloudEvent(KnativeComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "transportoptions": 
            case "transportOptions": {
                this.getOrCreateConfiguration(target).setTransportOptions(KnativeComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "typeid": 
            case "typeId": {
                this.getOrCreateConfiguration(target).setTypeId(KnativeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "apiversion": 
            case "apiVersion": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "ceoverride": 
            case "ceOverride": {
                return Map.class;
            }
            case "cloudeventsspecversion": 
            case "cloudEventsSpecVersion": {
                return String.class;
            }
            case "cloudeventstype": 
            case "cloudEventsType": {
                return String.class;
            }
            case "configuration": {
                return KnativeConfiguration.class;
            }
            case "consumerfactory": 
            case "consumerFactory": {
                return KnativeConsumerFactory.class;
            }
            case "environment": {
                return KnativeEnvironment.class;
            }
            case "environmentpath": 
            case "environmentPath": {
                return String.class;
            }
            case "filters": {
                return Map.class;
            }
            case "kind": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "name": {
                return String.class;
            }
            case "producerfactory": 
            case "producerFactory": {
                return KnativeProducerFactory.class;
            }
            case "reply": {
                return Boolean.class;
            }
            case "replywithcloudevent": 
            case "replyWithCloudEvent": {
                return Boolean.TYPE;
            }
            case "transportoptions": 
            case "transportOptions": {
                return Map.class;
            }
            case "typeid": 
            case "typeId": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        KnativeComponent target = (KnativeComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "apiversion": 
            case "apiVersion": {
                return this.getOrCreateConfiguration(target).getApiVersion();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "ceoverride": 
            case "ceOverride": {
                return this.getOrCreateConfiguration(target).getCeOverride();
            }
            case "cloudeventsspecversion": 
            case "cloudEventsSpecVersion": {
                return this.getOrCreateConfiguration(target).getCloudEventsSpecVersion();
            }
            case "cloudeventstype": 
            case "cloudEventsType": {
                return this.getOrCreateConfiguration(target).getCloudEventsType();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "consumerfactory": 
            case "consumerFactory": {
                return target.getConsumerFactory();
            }
            case "environment": {
                return this.getOrCreateConfiguration(target).getEnvironment();
            }
            case "environmentpath": 
            case "environmentPath": {
                return target.getEnvironmentPath();
            }
            case "filters": {
                return this.getOrCreateConfiguration(target).getFilters();
            }
            case "kind": {
                return this.getOrCreateConfiguration(target).getKind();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "name": {
                return this.getOrCreateConfiguration(target).getName();
            }
            case "producerfactory": 
            case "producerFactory": {
                return target.getProducerFactory();
            }
            case "reply": {
                return this.getOrCreateConfiguration(target).getReply();
            }
            case "replywithcloudevent": 
            case "replyWithCloudEvent": {
                return this.getOrCreateConfiguration(target).isReplyWithCloudEvent();
            }
            case "transportoptions": 
            case "transportOptions": {
                return this.getOrCreateConfiguration(target).getTransportOptions();
            }
            case "typeid": 
            case "typeId": {
                return this.getOrCreateConfiguration(target).getTypeId();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ceoverride": 
            case "ceOverride": {
                return String.class;
            }
            case "filters": {
                return String.class;
            }
            case "transportoptions": 
            case "transportOptions": {
                return Object.class;
            }
        }
        return null;
    }
}

