/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.service.ServiceHelper;

public class KnativeProducer
extends DefaultAsyncProducer {
    final AsyncProcessor processor;

    public KnativeProducer(Endpoint endpoint, Processor processor, Processor ... processors) throws Exception {
        super(endpoint);
        ArrayList<Processor> elements = new ArrayList<Processor>(1 + processors.length);
        elements.add(processor);
        Collections.addAll(elements, processors);
        ExtendedCamelContext ecc = this.getEndpoint().getCamelContext().adapt(ExtendedCamelContext.class);
        Processor pipeline = ecc.getProcessorFactory().createProcessor(ecc, "Pipeline", new Object[]{elements});
        this.processor = AsyncProcessorConverterHelper.convert(pipeline);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.processor.process(exchange, callback);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }

    @Override
    protected void doSuspend() throws Exception {
        ServiceHelper.suspendService(this.processor);
    }

    @Override
    protected void doResume() throws Exception {
        ServiceHelper.resumeService(this.processor);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.processor);
    }
}

