/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import krati.core.array.SimpleDataArray;
import krati.core.segment.AddressFormat;
import krati.core.segment.MemorySegment;
import krati.core.segment.Segment;
import krati.core.segment.SegmentIndexBuffer;
import krati.core.segment.SegmentManager;
import krati.util.Chronos;
import krati.util.DaemonThreadFactory;
import org.apache.log4j.Logger;

class SimpleDataArrayCompactor
implements Runnable {
    private static final Logger _log = Logger.getLogger(SimpleDataArrayCompactor.class);
    private ExecutorService _executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
    private SimpleDataArray _dataArray;
    private volatile boolean _enabled = true;
    private long _shutdownTimeout = 10L;
    private volatile double _compactLoadFactor;
    private volatile State _state = State.DONE;
    private volatile Segment _segTarget;
    private final ArrayList<Segment> _segSourceList;
    private final ReentrantLock _lock = new ReentrantLock();
    private final CompactionUpdateManager _updateManager;
    private final AtomicBoolean _newCycle = new AtomicBoolean(false);
    private final ConcurrentLinkedQueue<Segment> _targetQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Segment> _compactedQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Segment> _freeQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger _segPermits = new AtomicInteger(0);
    private final Set<Segment> _ignoredSegs = Collections.synchronizedSet(new HashSet());
    private ByteBuffer _buffer = null;
    private static Comparator<Segment> _segmentLoadCmp = new Comparator<Segment>(){

        @Override
        public int compare(Segment s1, Segment s2) {
            double load2;
            double load1 = s1.getLoadSize();
            return load1 < (load2 = (double)s2.getLoadSize()) ? -1 : (load1 == load2 ? 0 : 1);
        }
    };

    public SimpleDataArrayCompactor(SimpleDataArray dataArray) {
        this(dataArray, 0.5, 1000);
    }

    public SimpleDataArrayCompactor(SimpleDataArray dataArray, double compactLoadFactor) {
        this(dataArray, compactLoadFactor, 1000);
    }

    public SimpleDataArrayCompactor(SimpleDataArray dataArray, double compactLoadFactor, int compactBatchSize) {
        this._dataArray = dataArray;
        this._compactLoadFactor = compactLoadFactor;
        this._segSourceList = new ArrayList();
        this._updateManager = new CompactionUpdateManager(compactBatchSize);
    }

    public double getCompactLoadFactor() {
        return this._compactLoadFactor;
    }

    private void flushSegmentIndexBuffers() {
        SegmentManager segManager = this._dataArray.getSegmentManager();
        if (segManager != null) {
            segManager.flushSegmentIndexBuffers();
        }
    }

    private void freeCompactedSegments() {
        SegmentManager segManager = this._dataArray.getSegmentManager();
        if (segManager == null) {
            return;
        }
        while (!this._freeQueue.isEmpty()) {
            Segment seg = (Segment)this._freeQueue.remove();
            try {
                segManager.freeSegment(seg);
            }
            catch (Exception e) {
                _log.error((Object)("failed to free Segment " + seg.getSegmentId() + ": " + seg.getStatus()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inspect() {
        SegmentManager segManager = this._dataArray.getSegmentManager();
        if (segManager == null) {
            return false;
        }
        SegmentManager segmentManager = segManager;
        synchronized (segmentManager) {
            Segment segCurrent = this._dataArray.getCurrentSegment();
            ArrayList<Segment> recycleList = new ArrayList<Segment>();
            int cnt = segManager.getSegmentCount();
            for (int i = 0; i < cnt; ++i) {
                Segment seg = segManager.getSegment(i);
                if (seg == null || seg.getMode() != Segment.Mode.READ_ONLY || seg == segCurrent || !(seg.getLoadFactor() < this._compactLoadFactor) || this._ignoredSegs.contains(seg)) continue;
                recycleList.add(seg);
            }
            if (recycleList.size() == 0) {
                this._segPermits.set(0);
                return false;
            }
            Collections.sort(recycleList, _segmentLoadCmp);
            double totalFactor = 0.0;
            int len = Math.min(3, recycleList.size());
            for (int i = 0; i < len; ++i) {
                Segment seg = (Segment)recycleList.get(i);
                if (!(totalFactor < 0.8)) break;
                if (!((totalFactor += Math.max(0.0, seg.getLoadFactor())) < 0.8)) continue;
                this._segSourceList.add(seg);
            }
            try {
                for (Segment seg : this._segSourceList) {
                    _log.info((Object)("Segment " + seg.getSegmentId() + " load factor=" + (double)((long)(seg.getLoadFactor() * 10000.0)) / 10000.0));
                }
            }
            catch (ConcurrentModificationException e) {
                this._segPermits.set(0);
                this._segSourceList.clear();
                return false;
            }
            this._segPermits.set(Math.max(this._segSourceList.size() - 1, 0));
            _log.info((Object)"inspect done");
            return true;
        }
    }

    private boolean compact() throws IOException {
        try {
            boolean sibEnabled = this._dataArray.isSibEnabled();
            this._segTarget = this._dataArray.getSegmentManager().nextSegment();
            for (Segment seg : this._segSourceList) {
                if (!this._enabled) {
                    try {
                        this._updateManager.endUpdate(this._segTarget);
                    }
                    catch (Exception e) {
                        _log.warn((Object)"compact abort", (Throwable)e);
                    }
                    _log.info((Object)("ignored Segment " + seg.getSegmentId()));
                    continue;
                }
                try {
                    if (!this.compact(seg, this._segTarget, sibEnabled)) continue;
                    this._compactedQueue.add(seg);
                }
                catch (Exception e) {
                    if (!this._dataArray.isOpen()) continue;
                    this._ignoredSegs.add(seg);
                    _log.error((Object)("failed to compact Segment " + seg.getSegmentId()), (Throwable)e);
                }
            }
            if (sibEnabled && !this._dataArray.isSibEnabled()) {
                this._dataArray.getSegmentManager().openSegmentIndexBuffer(this._segTarget.getSegmentId()).markAsDirty();
            }
            this._targetQueue.add(this._segTarget);
            _log.info((Object)("bytes transferred to   " + this._segTarget.getSegmentId() + ": " + (this._segTarget.getAppendPosition() - 128L)));
        }
        catch (ConcurrentModificationException e1) {
            this._segSourceList.clear();
            return false;
        }
        catch (Exception e2) {
            _log.warn((Object)e2.getMessage(), (Throwable)e2);
            return false;
        }
        _log.info((Object)"compact done");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compact(Segment segment, Segment segTarget, boolean sibEnabled) throws IOException {
        SegmentIndexBuffer sibSource;
        if (sibEnabled && (sibSource = this._dataArray.getSegmentManager().loadSegmentIndexBuffer(segment.getSegmentId(), segment.getLastForcedTime())) != null) {
            return this.compact(segment, sibSource, segTarget);
        }
        Segment segSource = segment;
        int segSourceId = segSource.getSegmentId();
        int segTargetId = segTarget.getSegmentId();
        Chronos c = new Chronos();
        if (!segment.canReadFromBuffer() && segment.getLoadFactor() > 0.1) {
            segSource = new BufferedSegment(segment, this.getByteBuffer((int)segment.getInitialSize()));
            _log.info((Object)("buffering: " + c.tick() + " ms"));
        }
        SegmentIndexBuffer sibTarget = sibEnabled ? this._dataArray.getSegmentManager().openSegmentIndexBuffer(segTargetId) : null;
        long sizeLimit = segTarget.getInitialSize();
        long bytesTransferred = 0L;
        boolean succ = true;
        try {
            AddressFormat addrFormat = this._dataArray._addressFormat;
            int cnt = this._dataArray.length();
            for (int index = 0; index < cnt; ++index) {
                long oldAddress = this._dataArray.getAddress(index);
                int oldSegPos = addrFormat.getOffset(oldAddress);
                int oldSegInd = addrFormat.getSegment(oldAddress);
                int length = addrFormat.getDataSize(oldAddress);
                if (oldSegInd != segSourceId || oldSegPos < 128) continue;
                if (length == 0) {
                    length = segSource.readInt(oldSegPos);
                }
                int byteCnt = 4 + length;
                long newSegPos = segTarget.getAppendPosition();
                long newAddress = addrFormat.composeAddress((int)newSegPos, segTargetId, length);
                if (segTarget.getAppendPosition() + (long)byteCnt >= sizeLimit) {
                    succ = false;
                    break;
                }
                segSource.transferTo(oldSegPos, byteCnt, segTarget);
                bytesTransferred += (long)byteCnt;
                if (sibTarget != null) {
                    sibTarget.add(index, (int)newSegPos);
                }
                this._updateManager.addUpdate(index, byteCnt, newAddress, oldAddress, segTarget);
            }
            this._updateManager.endUpdate(segTarget);
            _log.info((Object)("bytes transferred from " + segSource.getSegmentId() + ": " + bytesTransferred + " time: " + c.tick() + " ms"));
            boolean bl = succ;
            return bl;
        }
        finally {
            if (segSource.getClass() == BufferedSegment.class) {
                segSource.close(false);
                segSource = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compact(Segment segment, SegmentIndexBuffer sibSource, Segment segTarget) throws IOException {
        Segment segSource = segment;
        int segSourceId = segSource.getSegmentId();
        int segTargetId = segTarget.getSegmentId();
        Chronos c = new Chronos();
        if (!segment.canReadFromBuffer() && segment.getLoadFactor() > 0.1) {
            segSource = new BufferedSegment(segment, this.getByteBuffer((int)segment.getInitialSize()));
            _log.info((Object)("buffering: " + c.tick() + " ms"));
        }
        SegmentIndexBuffer sibTarget = this._dataArray.getSegmentManager().openSegmentIndexBuffer(segTargetId);
        long sizeLimit = segTarget.getInitialSize();
        long bytesTransferred = 0L;
        boolean succ = true;
        try {
            AddressFormat addrFormat = this._dataArray._addressFormat;
            SegmentIndexBuffer.IndexOffset reuse = new SegmentIndexBuffer.IndexOffset();
            int cnt = sibSource.size();
            for (int i = 0; i < cnt; ++i) {
                sibSource.get(i, reuse);
                int index = reuse.getIndex();
                int sibSegPos = reuse.getOffset();
                long oldAddress = this._dataArray.getAddress(index);
                int oldSegPos = addrFormat.getOffset(oldAddress);
                if (sibSegPos != oldSegPos) continue;
                int oldSegInd = addrFormat.getSegment(oldAddress);
                int length = addrFormat.getDataSize(oldAddress);
                if (oldSegInd != segSourceId || oldSegPos < 128) continue;
                if (length == 0) {
                    length = segSource.readInt(oldSegPos);
                }
                int byteCnt = 4 + length;
                long newSegPos = segTarget.getAppendPosition();
                long newAddress = addrFormat.composeAddress((int)newSegPos, segTargetId, length);
                if (segTarget.getAppendPosition() + (long)byteCnt >= sizeLimit) {
                    succ = false;
                    break;
                }
                segSource.transferTo(oldSegPos, byteCnt, segTarget);
                bytesTransferred += (long)byteCnt;
                sibTarget.add(index, (int)newSegPos);
                this._updateManager.addUpdate(index, byteCnt, newAddress, oldAddress, segTarget);
            }
            this._updateManager.endUpdate(segTarget);
            _log.info((Object)("bytes fastscanned from " + segSource.getSegmentId() + ": " + bytesTransferred + " time: " + c.tick() + " ms"));
            boolean bl = succ;
            return bl;
        }
        finally {
            if (segSource.getClass() == BufferedSegment.class) {
                segSource.close(false);
                segSource = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this._enabled) {
            if (this._newCycle.compareAndSet(true, false)) {
                this._lock.lock();
                try {
                    this.reset();
                    this._state = State.INIT;
                    _log.info((Object)"cycle init");
                    this.flushSegmentIndexBuffers();
                    this.freeCompactedSegments();
                    if (!this.inspect() || this.compact()) continue;
                    continue;
                }
                catch (Exception e) {
                    _log.error((Object)"compaction failure", (Throwable)e);
                    continue;
                }
                finally {
                    this.reset();
                    this._state = State.DONE;
                    _log.info((Object)"cycle done");
                    this._lock.unlock();
                    continue;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                _log.warn((Object)e.getMessage());
            }
        }
    }

    final void start() {
        this._enabled = true;
        this._ignoredSegs.clear();
        this._executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
        this._executor.execute(this);
    }

    final void shutdown() {
        this._enabled = false;
        this._ignoredSegs.clear();
        if (this._executor != null && !this._executor.isShutdown()) {
            try {
                this._executor.shutdown();
                _log.info((Object)"shutdown");
            }
            catch (Exception e) {
                _log.warn((Object)"shutdown abort", (Throwable)e);
            }
            try {
                this._executor.awaitTermination(this._shutdownTimeout, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                _log.warn((Object)"shutdown abort", (Throwable)e);
            }
            if (this._segTarget != null) {
                try {
                    this._updateManager.endUpdate(this._segTarget);
                }
                catch (Exception e) {
                    _log.warn((Object)"shutdown abort", (Throwable)e);
                }
            }
        }
        this._executor = null;
        this._state = State.DONE;
    }

    final boolean isStarted() {
        return this._state != State.DONE;
    }

    final void clear() {
        this.reset();
        this._freeQueue.clear();
        this._targetQueue.clear();
        this._compactedQueue.clear();
        while (!this._updateManager.isServiceQueueEmpty()) {
            CompactionUpdateBatch batch = this._updateManager.pollBatch();
            this._updateManager.recycleBatch(batch);
        }
    }

    private final void reset() {
        this._segTarget = null;
        this._segPermits.set(0);
        this._segSourceList.clear();
        this._updateManager.clear();
    }

    protected Segment peekTargetSegment() {
        return this._targetQueue.peek();
    }

    protected Segment pollTargetSegment() {
        return this._targetQueue.poll();
    }

    protected CompactionUpdateBatch pollCompactionBatch() {
        return this._updateManager.pollBatch();
    }

    protected boolean recycleCompactionBatch(CompactionUpdateBatch batch) {
        return this._updateManager.recycleBatch(batch);
    }

    protected ByteBuffer getByteBuffer(int bufferLength) {
        if (this._buffer == null) {
            this._buffer = ByteBuffer.wrap(new byte[bufferLength]);
            _log.info((Object)"ByteBuffer allocated for buffering");
        }
        return this._buffer;
    }

    final ConcurrentLinkedQueue<Segment> getCompactedQueue() {
        return this._compactedQueue;
    }

    final ConcurrentLinkedQueue<Segment> getFreeQueue() {
        return this._freeQueue;
    }

    final boolean getAndDecrementSegmentPermit() {
        return this._segPermits.getAndDecrement() > 0;
    }

    final Segment getTargetSegment() {
        return this._segTarget;
    }

    final void startsCycle() {
        this._newCycle.set(true);
    }

    static class BufferedSegment
    extends MemorySegment {
        private ByteBuffer _byteBuffer = null;

        public BufferedSegment(Segment segment, ByteBuffer buffer) throws IOException {
            super(segment.getSegmentId(), segment.getSegmentFile(), segment.getInitialSizeMB(), segment.getMode());
            this._byteBuffer = buffer;
            this.init();
        }

        @Override
        protected void init() throws IOException {
            if (this._byteBuffer == null) {
                return;
            }
            super.init();
        }

        @Override
        protected ByteBuffer initByteBuffer() {
            this._byteBuffer.clear();
            return this._byteBuffer;
        }
    }

    static class CompactionUpdateManager {
        private final int _batchSize;
        private final ConcurrentLinkedQueue<CompactionUpdateBatch> _serviceBatchQueue;
        private final ConcurrentLinkedQueue<CompactionUpdateBatch> _recycleBatchQueue;
        private int _batchServiceIdCounter = 0;
        private CompactionUpdateBatch _batch;

        public CompactionUpdateManager(int batchSize) {
            this._batchSize = batchSize;
            this._serviceBatchQueue = new ConcurrentLinkedQueue();
            this._recycleBatchQueue = new ConcurrentLinkedQueue();
            this.nextBatch();
        }

        private void nextBatch() {
            this._batch = this._recycleBatchQueue.poll();
            if (this._batch == null) {
                this._batch = new CompactionUpdateBatch(this._batchSize);
            }
            this._batch.clear();
            this._batch.setServiceId(this._batchServiceIdCounter++);
        }

        public boolean isServiceQueueEmpty() {
            return this._serviceBatchQueue.isEmpty();
        }

        public boolean isRecycleQueueEmpty() {
            return this._recycleBatchQueue.isEmpty();
        }

        public CompactionUpdateBatch pollBatch() {
            return this._serviceBatchQueue.poll();
        }

        public boolean recycleBatch(CompactionUpdateBatch batch) {
            batch.clear();
            return this._recycleBatchQueue.add(batch);
        }

        public void addUpdate(int index, int dataSize, long dataAddr, long origAddr, Segment segTarget) throws IOException {
            try {
                this._batch.add(index, dataSize, dataAddr, origAddr);
            }
            catch (BufferOverflowException e) {
                segTarget.force();
                this._batch.setTargetSegment(segTarget);
                if (_log.isTraceEnabled()) {
                    _log.trace((Object)("compaction batch " + this._batch.getDescriptiveId()));
                }
                this._serviceBatchQueue.add(this._batch);
                this.nextBatch();
                this._batch.add(index, dataSize, dataAddr, origAddr);
            }
        }

        public void endUpdate(Segment segTarget) throws IOException {
            segTarget.force();
            if (this._batch.size() > 0) {
                this._batch.setTargetSegment(segTarget);
                if (_log.isTraceEnabled()) {
                    _log.trace((Object)("compaction batch " + this._batch.getDescriptiveId()));
                }
                this._serviceBatchQueue.add(this._batch);
                this._batchServiceIdCounter = 0;
                this.nextBatch();
            }
        }

        public void clear() {
            this._batchServiceIdCounter = 0;
            this._batch.clear();
            this._batch.setServiceId(this._batchServiceIdCounter++);
        }
    }

    static class CompactionUpdateBatch {
        static int _counter = 0;
        final int _batchId;
        final int _capacity;
        final int _unitSize = 24;
        final ByteBuffer _buffer;
        Segment _segTarget = null;
        int _dataSizeTotal = 0;
        int _serviceId = 0;

        CompactionUpdateBatch(int capacity) {
            this._capacity = capacity;
            this._batchId = _counter++;
            this._buffer = ByteBuffer.allocate(this._capacity * 24);
        }

        public void clear() {
            this._buffer.clear();
            this._segTarget = null;
            this._dataSizeTotal = 0;
            this._serviceId = 0;
        }

        public int getCapacity() {
            return this._capacity;
        }

        public int getByteCapacity() {
            return this._buffer.capacity();
        }

        public ByteBuffer getInternalBuffer() {
            return this._buffer;
        }

        public int size() {
            return this._buffer.position() / 24;
        }

        public boolean isEmpty() {
            return this._buffer.position() == 0;
        }

        public int getBatchId() {
            return this._batchId;
        }

        public int getServiceId() {
            return this._serviceId;
        }

        public String getDescriptiveId() {
            return (this._segTarget == null ? "?[" : this._segTarget.getSegmentId() + "[") + this._serviceId + "]";
        }

        public Segment getTargetSegment() {
            return this._segTarget;
        }

        public void add(int index, int dataSize, long dataAddr, long origAddr) {
            this._buffer.putInt(index);
            this._buffer.putInt(dataSize);
            this._buffer.putLong(dataAddr);
            this._buffer.putLong(origAddr);
            this._dataSizeTotal += dataSize;
        }

        public CompactionUpdate get(int i) {
            return new CompactionUpdate(this.getUpdateIndex(i), this.getUpdateDataSize(i), this.getUpdateDataAddr(i), this.getOriginDataAddr(i));
        }

        public int getUpdateIndex(int i) {
            return this._buffer.getInt(i * 24);
        }

        public int getUpdateDataSize(int i) {
            return this._buffer.getInt(i * 24 + 4);
        }

        public long getUpdateDataAddr(int i) {
            return this._buffer.getLong(i * 24 + 8);
        }

        public long getOriginDataAddr(int i) {
            return this._buffer.getLong(i * 24 + 16);
        }

        public int getDataSizeTotal() {
            return this._dataSizeTotal;
        }

        void setTargetSegment(Segment seg) {
            this._segTarget = seg;
        }

        void setServiceId(int serviceId) {
            this._serviceId = serviceId;
        }
    }

    static class CompactionUpdate {
        final int _index;
        final int _dataSize;
        final long _dataAddr;
        final long _origAddr;

        CompactionUpdate(int index, int dataSize, long dataAddr, long origAddr) {
            this._index = index;
            this._dataSize = dataSize;
            this._dataAddr = dataAddr;
            this._origAddr = origAddr;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getClass().getSimpleName());
            buf.append("{index=");
            buf.append(this._index);
            buf.append(",  dataSize=");
            buf.append(this._dataSize);
            buf.append(",  dataAddr=");
            buf.append(this._dataAddr);
            buf.append(",  origAddr=");
            buf.append(this._origAddr);
            buf.append("}");
            return buf.toString();
        }
    }

    static enum State {
        INIT,
        DONE;

    }
}

