/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import krati.Mode;
import krati.array.Array;
import krati.array.DynamicArray;
import krati.core.array.AddressArray;
import krati.core.array.basic.AbstractRecoverableArray;
import krati.core.array.basic.ArrayExpandListener;
import krati.core.array.basic.MemoryLongArray;
import krati.core.array.entry.EntryLongFactory;
import krati.core.array.entry.EntryPersistListener;
import krati.core.array.entry.EntryValueLong;
import org.apache.log4j.Logger;

public class DynamicLongArray
extends AbstractRecoverableArray<EntryValueLong>
implements AddressArray,
DynamicArray,
ArrayExpandListener {
    private static final int _subArrayBits = 16;
    private static final int _subArraySize = 65536;
    private static final Logger _log = Logger.getLogger(DynamicLongArray.class);
    private MemoryLongArray _internalArray;
    private float _expandRate = 0.0f;
    private volatile Mode _mode = Mode.OPEN;

    public DynamicLongArray(int entrySize, int maxEntries, File directory) throws Exception {
        super(65536, 8, entrySize, maxEntries, directory, new EntryLongFactory());
    }

    @Override
    protected Logger getLogger() {
        return _log;
    }

    @Override
    protected void loadArrayFileData() throws IOException {
        long maxScn = this._arrayFile.getLwmScn();
        try {
            this._internalArray = new MemoryLongArray(16);
            this._arrayFile.load(this._internalArray);
            this.expandCapacity(this._internalArray.length() - 1);
            this._internalArray.setArrayExpandListener(this);
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException("Failed to load array file", e);
        }
        this._entryManager.setWaterMarks(maxScn, maxScn);
    }

    @Override
    public void saveHWMark(long endOfPeriod) {
        if (this.getHWMark() < endOfPeriod) {
            try {
                this.set(0, this.get(0), endOfPeriod);
            }
            catch (Exception e) {
                _log.error((Object)("Failed to saveHWMark " + endOfPeriod), (Throwable)e);
            }
        } else if (0L < endOfPeriod && endOfPeriod < this.getLWMark()) {
            try {
                this._entryManager.sync();
            }
            catch (Exception e) {
                _log.error((Object)("Failed to saveHWMark" + endOfPeriod), (Throwable)e);
            }
            this._entryManager.setWaterMarks(endOfPeriod, endOfPeriod);
        }
    }

    @Override
    public void clear() {
        if (this._internalArray != null) {
            this._internalArray.clear();
        }
        this._entryManager.clear();
        try {
            this._arrayFile.reset(this._internalArray, this._entryManager.getLWMark());
        }
        catch (IOException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public long get(int index) {
        return this._internalArray.get(index);
    }

    @Override
    public void set(int index, long value, long scn) throws Exception {
        this._internalArray.set(index, value);
        this._entryManager.addToPreFillEntryLong(index, value, scn);
    }

    @Override
    public void setCompactionAddress(int index, long address, long scn) throws Exception {
        this._internalArray.set(index, address);
        this._entryManager.addToPreFillEntryLongCompaction(index, address, scn);
    }

    @Override
    public long[] getInternalArray() {
        return this._internalArray.getInternalArray();
    }

    @Override
    public EntryPersistListener getPersistListener() {
        return this.getEntryManager().getPersistListener();
    }

    @Override
    public void setPersistListener(EntryPersistListener persistListener) {
        this.getEntryManager().setPersistListener(persistListener);
    }

    @Override
    public float getExpandRate() {
        return this._expandRate;
    }

    @Override
    public void setExpandRate(float rate) {
        if (rate < 0.0f || rate > 1.0f) {
            throw new IllegalArgumentException("invalid value: " + rate);
        }
        this._expandRate = rate;
    }

    @Override
    public void expandCapacity(int index) throws Exception {
        int newLength;
        if (index < this._length) {
            return;
        }
        long capacity = ((long)(index >> 16) + 1L) * 65536L;
        long expandTo = ((long)this._length + (long)((float)this._length * this.getExpandRate()) >> 16) * 65536L;
        if (capacity < expandTo) {
            capacity = expandTo;
        }
        int n = newLength = capacity < Integer.MAX_VALUE ? (int)capacity : Integer.MAX_VALUE;
        if (this._internalArray.length() < newLength) {
            this._internalArray.expandCapacity(newLength - 1);
        }
        this._arrayFile.setArrayLength(newLength, null);
        this._length = newLength;
        _log.info((Object)("Expanded: _length=" + this._length));
    }

    @Override
    public void arrayExpanded(DynamicArray dynArray) {
        if (dynArray == this._internalArray) {
            try {
                this.expandCapacity(dynArray.length() - 1);
            }
            catch (Exception e) {
                _log.error((Object)("Failed to expand: length=" + dynArray.length()));
            }
        }
    }

    public final int subArrayLength() {
        return 65536;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._mode == Mode.CLOSED) {
            return;
        }
        try {
            this.sync();
            this._entryManager.clear();
            this._arrayFile.close();
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
        finally {
            this._internalArray = null;
            this._arrayFile = null;
            this._length = 0;
            this._mode = Mode.CLOSED;
        }
    }

    @Override
    public synchronized void open() throws IOException {
        if (this._mode == Mode.OPEN) {
            return;
        }
        File file = new File(this._directory, "indexes.dat");
        this._arrayFile = this.openArrayFile(file, this._length, 8);
        this._length = this._arrayFile.getArrayLength();
        this.init();
        this._mode = Mode.OPEN;
        this.getLogger().info((Object)("length:" + this._length + " entrySize:" + this._entryManager.getMaxEntrySize() + " maxEntries:" + this._entryManager.getMaxEntries() + " directory:" + this._directory.getAbsolutePath() + " arrayFile:" + this._arrayFile.getName()));
    }

    @Override
    public boolean isOpen() {
        return this._mode == Mode.OPEN;
    }

    @Override
    public final Array.Type getType() {
        return Array.Type.DYNAMIC;
    }
}

