/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import krati.Mode;
import krati.array.Array;
import krati.array.LongArray;
import krati.core.array.AddressArray;
import krati.core.array.basic.AbstractRecoverableArray;
import krati.core.array.entry.EntryLongFactory;
import krati.core.array.entry.EntryPersistListener;
import krati.core.array.entry.EntryValueLong;
import org.apache.log4j.Logger;

public class StaticLongArray
extends AbstractRecoverableArray<EntryValueLong>
implements AddressArray {
    private static final Logger _log = Logger.getLogger(StaticLongArray.class);
    private long[] _internalArray;
    private volatile Mode _mode = Mode.OPEN;

    public StaticLongArray(int length, int entrySize, int maxEntries, File homeDirectory) throws Exception {
        super(length, 8, entrySize, maxEntries, homeDirectory, new EntryLongFactory());
    }

    @Override
    protected Logger getLogger() {
        return _log;
    }

    @Override
    protected void loadArrayFileData() throws IOException {
        long maxScn = this._arrayFile.getLwmScn();
        if (this._arrayFile.getArrayLength() != this._length) {
            throw new IOException("Invalid array length: " + this._length);
        }
        this._internalArray = this._arrayFile.loadLongArray();
        this._entryManager.setWaterMarks(maxScn, maxScn);
        _log.info((Object)("Data loaded successfully from file " + this._arrayFile.getName()));
    }

    @Override
    public void saveHWMark(long endOfPeriod) {
        if (this.getHWMark() < endOfPeriod) {
            try {
                this.set(0, this.get(0), endOfPeriod);
            }
            catch (Exception e) {
                _log.error((Object)("Failed to saveHWMark " + endOfPeriod), (Throwable)e);
            }
        } else if (0L < endOfPeriod && endOfPeriod < this.getLWMark()) {
            try {
                this._entryManager.sync();
            }
            catch (Exception e) {
                _log.error((Object)("Failed to saveHWMark" + endOfPeriod), (Throwable)e);
            }
            this._entryManager.setWaterMarks(endOfPeriod, endOfPeriod);
        }
    }

    @Override
    public void clear() {
        if (this._internalArray != null) {
            for (int i = 0; i < this._internalArray.length; ++i) {
                this._internalArray[i] = 0L;
            }
        }
        this._entryManager.clear();
        try {
            this._arrayFile.reset(this._internalArray, this._entryManager.getLWMark());
        }
        catch (IOException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public long get(int index) {
        return this._internalArray[index];
    }

    @Override
    public void set(int index, long value, long scn) throws Exception {
        this._internalArray[index] = value;
        this._entryManager.addToPreFillEntryLong(index, value, scn);
    }

    @Override
    public void setCompactionAddress(int index, long address, long scn) throws Exception {
        this._internalArray[index] = address;
        this._entryManager.addToPreFillEntryLongCompaction(index, address, scn);
    }

    @Override
    public float getExpandRate() {
        return 0.0f;
    }

    @Override
    public void setExpandRate(float rate) {
    }

    @Override
    public void expandCapacity(int index) throws Exception {
    }

    @Override
    public long[] getInternalArray() {
        return this._internalArray;
    }

    public void wrap(LongArray newArray) throws Exception {
        if (this.length() != newArray.length()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._internalArray = newArray.getInternalArray();
        this._arrayFile.reset(this._internalArray);
        this._entryManager.clear();
    }

    @Override
    public EntryPersistListener getPersistListener() {
        return this.getEntryManager().getPersistListener();
    }

    @Override
    public void setPersistListener(EntryPersistListener persistListener) {
        this.getEntryManager().setPersistListener(persistListener);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._mode == Mode.CLOSED) {
            return;
        }
        try {
            this.sync();
            this._entryManager.clear();
            this._arrayFile.close();
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
        finally {
            this._internalArray = null;
            this._arrayFile = null;
            this._length = 0;
            this._mode = Mode.CLOSED;
        }
    }

    @Override
    public synchronized void open() throws IOException {
        if (this._mode == Mode.OPEN) {
            return;
        }
        File file = new File(this._directory, "indexes.dat");
        this._arrayFile = this.openArrayFile(file, this._length, 8);
        this._length = this._arrayFile.getArrayLength();
        this.init();
        this._mode = Mode.OPEN;
        this.getLogger().info((Object)("length:" + this._length + " entrySize:" + this._entryManager.getMaxEntrySize() + " maxEntries:" + this._entryManager.getMaxEntries() + " directory:" + this._directory.getAbsolutePath() + " arrayFile:" + this._arrayFile.getName()));
    }

    @Override
    public boolean isOpen() {
        return this._mode == Mode.OPEN;
    }

    @Override
    public final Array.Type getType() {
        return Array.Type.STATIC;
    }
}

