/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import krati.array.Array;
import krati.array.ShortArray;
import krati.core.array.basic.AbstractRecoverableArray;
import krati.core.array.entry.EntryShortFactory;
import krati.core.array.entry.EntryValueShort;
import org.apache.log4j.Logger;

public class StaticShortArray
extends AbstractRecoverableArray<EntryValueShort>
implements ShortArray {
    private static final Logger _log = Logger.getLogger(StaticShortArray.class);
    private short[] _internalArray;

    public StaticShortArray(int length, int entrySize, int maxEntries, File homeDirectory) throws Exception {
        super(length, 2, entrySize, maxEntries, homeDirectory, new EntryShortFactory());
    }

    @Override
    protected Logger getLogger() {
        return _log;
    }

    @Override
    protected void loadArrayFileData() throws IOException {
        long maxScn = this._arrayFile.getLwmScn();
        if (this._arrayFile.getArrayLength() != this._length) {
            throw new IOException("Invalid array length: " + this._length);
        }
        this._internalArray = this._arrayFile.loadShortArray();
        this._entryManager.setWaterMarks(maxScn, maxScn);
        _log.info((Object)("Data loaded successfully from file " + this._arrayFile.getName()));
    }

    @Override
    public void saveHWMark(long endOfPeriod) {
        if (this.getHWMark() < endOfPeriod) {
            try {
                this.set(0, this.get(0), endOfPeriod);
            }
            catch (Exception e) {
                _log.error((Object)("Failed to saveHWMark " + endOfPeriod), (Throwable)e);
            }
        } else if (0L < endOfPeriod && endOfPeriod < this.getLWMark()) {
            try {
                this._entryManager.sync();
            }
            catch (Exception e) {
                _log.error((Object)("Failed to saveHWMark" + endOfPeriod), (Throwable)e);
            }
            this._entryManager.setWaterMarks(endOfPeriod, endOfPeriod);
        }
    }

    @Override
    public void clear() {
        if (this._internalArray != null) {
            for (int i = 0; i < this._internalArray.length; ++i) {
                this._internalArray[i] = 0;
            }
        }
        this._entryManager.clear();
        try {
            this._arrayFile.reset(this._internalArray, this._entryManager.getLWMark());
        }
        catch (IOException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public short get(int index) {
        return this._internalArray[index];
    }

    @Override
    public void set(int index, short value, long scn) throws Exception {
        this._internalArray[index] = value;
        this._entryManager.addToPreFillEntryShort(index, value, scn);
    }

    @Override
    public short[] getInternalArray() {
        return this._internalArray;
    }

    @Override
    public final Array.Type getType() {
        return Array.Type.STATIC;
    }
}

