/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.entry;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import krati.core.array.entry.Entry;
import krati.core.array.entry.EntryValue;

public class EntryUtility {
    public static <T extends EntryValue> T[] sortEntriesToValues(Entry<T>[] entryArray) {
        int len = 0;
        Object[] valArray = null;
        if (entryArray == null) {
            return valArray;
        }
        for (Entry<T> e : entryArray) {
            len += e.size();
        }
        if (len == 0) {
            return valArray;
        }
        valArray = entryArray[0].getValueFactory().newValueArray(len);
        int i = 0;
        for (Entry<T> e : entryArray) {
            for (EntryValue val : e.getValueList()) {
                valArray[i++] = val;
            }
        }
        Arrays.sort(valArray);
        return valArray;
    }

    public static <T extends EntryValue> T[] sortEntriesToValues(List<Entry<T>> entryList) {
        int len = 0;
        Object[] valArray = null;
        if (entryList == null) {
            return valArray;
        }
        for (Entry<T> e : entryList) {
            len += e.size();
        }
        if (len == 0) {
            return valArray;
        }
        valArray = entryList.get(0).getValueFactory().newValueArray(len);
        int i = 0;
        for (Entry<T> e : entryList) {
            for (EntryValue val : e.getValueList()) {
                valArray[i++] = val;
            }
        }
        Arrays.sort(valArray);
        return valArray;
    }

    public static <T extends EntryValue> void sortEntriesById(List<Entry<T>> entryList) {
        if (entryList.size() > 0) {
            Collections.sort(entryList, new Comparator<Entry<?>>(){

                @Override
                public int compare(Entry<?> e1, Entry<?> e2) {
                    long v2;
                    long v1 = EntryUtility.getEntryId(e1.getFile().getName());
                    return v1 < (v2 = EntryUtility.getEntryId(e2.getFile().getName())) ? -1 : (v1 == v2 ? 0 : 1);
                }
            });
        }
    }

    public static long getEntryId(String entryFileName) {
        int ind2;
        int ind1 = entryFileName.indexOf("_") + 1;
        if (ind1 > 0 && (ind2 = entryFileName.indexOf("_", ind1)) > ind1) {
            String str = entryFileName.substring(ind1, ind2);
            try {
                return Long.parseLong(str);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 0L;
    }
}

