/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import krati.core.segment.MemorySegment;
import krati.core.segment.Segment;
import krati.core.segment.SegmentOverflowException;
import org.apache.log4j.Logger;

public class DirectBufferSegment
extends MemorySegment {
    private static Logger _log = Logger.getLogger(DirectBufferSegment.class);

    public DirectBufferSegment(int segmentId, File segmentFile, int initialSizeMB, Segment.Mode mode) throws IOException {
        super(segmentId, segmentFile, initialSizeMB, mode);
    }

    @Override
    protected Logger logger() {
        return _log;
    }

    @Override
    protected ByteBuffer initByteBuffer() {
        int bufferLength = (int)(this._initSizeMB < 2048 ? this._initSizeBytes : this._initSizeBytes - 1L);
        return ByteBuffer.allocateDirect(bufferLength);
    }

    @Override
    public void read(int pos, byte[] dst) throws IOException {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = this._buffer.get(pos + i);
        }
    }

    @Override
    public void read(int pos, byte[] dst, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = this._buffer.get(pos + i);
        }
    }

    @Override
    public int transferTo(int pos, int length, Segment targetSegment) throws IOException {
        if ((long)(pos + length) <= this._initSizeBytes) {
            byte[] dst = new byte[length];
            this.read(pos, dst);
            targetSegment.append(dst);
            return length;
        }
        throw new SegmentOverflowException(this, SegmentOverflowException.Type.READ_OVERFLOW);
    }

    @Override
    public int transferTo(int pos, int length, WritableByteChannel targetChannel) throws IOException {
        if (pos + length <= this._buffer.position()) {
            byte[] dst = new byte[length];
            this.read(pos, dst);
            targetChannel.write(ByteBuffer.wrap(dst));
            return length;
        }
        throw new SegmentOverflowException(this, SegmentOverflowException.Type.READ_OVERFLOW);
    }

    @Override
    public synchronized void force() throws IOException {
        if (this._channel == null) {
            return;
        }
        if (this.getMode() == Segment.Mode.READ_WRITE) {
            int offset = (int)this._channel.position();
            int length = this._buffer.position() - offset;
            if (length > 0) {
                byte[] dst = new byte[length];
                this.read(offset, dst);
                this._channel.write(ByteBuffer.wrap(dst));
            }
            long currentTime = System.currentTimeMillis();
            ByteBuffer bb = ByteBuffer.wrap(new byte[8]);
            bb.putLong(currentTime);
            bb.flip();
            this._channel.write(bb, 0L);
            this._lastForcedTime = currentTime;
        }
        this._channel.force(true);
        this.logger().info((Object)("Segment " + this.getSegmentId() + " forced: " + this.getStatus()));
    }
}

