/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import krati.core.segment.AbstractSegment;
import krati.core.segment.Segment;
import krati.core.segment.SegmentOverflowException;
import krati.core.segment.SegmentReadOnlyException;
import org.apache.log4j.Logger;

public class MappedSegment
extends AbstractSegment {
    private static final Logger _log = Logger.getLogger(MappedSegment.class);
    private MappedByteBuffer _mmapBuffer;

    public MappedSegment(int segmentId, File segmentFile, int initialSizeMB, Segment.Mode mode) throws IOException {
        super(segmentId, segmentFile, initialSizeMB, mode);
    }

    @Override
    protected void init() throws IOException {
        long bufferLength;
        long l = bufferLength = this._initSizeMB < 2048 ? this._initSizeBytes : this._initSizeBytes - 1L;
        if (!this.getSegmentFile().exists()) {
            if (!this.getSegmentFile().createNewFile()) {
                String msg = "Failed to create " + this.getSegmentFile().getAbsolutePath();
                _log.error((Object)msg);
                throw new IOException(msg);
            }
            RandomAccessFile raf = new RandomAccessFile(this.getSegmentFile(), "rw");
            raf.setLength(this.getInitialSize());
            raf.close();
        }
        if (this.getMode() == Segment.Mode.READ_ONLY) {
            this._raf = new RandomAccessFile(this.getSegmentFile(), "r");
            this.checkSegmentSize();
            this._channel = this._raf.getChannel();
            this._mmapBuffer = this._channel.map(FileChannel.MapMode.READ_ONLY, 0L, bufferLength);
            this.loadHeader();
            _log.info((Object)("Segment " + this.getSegmentId() + " loaded: " + this.getHeader()));
        } else {
            this._raf = new RandomAccessFile(this.getSegmentFile(), "rw");
            this.checkSegmentSize();
            this._channel = this._raf.getChannel();
            this._mmapBuffer = this._channel.map(FileChannel.MapMode.READ_WRITE, 0L, bufferLength);
            this.initHeader();
            _log.info((Object)("Segment " + this.getSegmentId() + " initialized: " + this.getStatus()));
        }
    }

    @Override
    public long getAppendPosition() {
        return this._mmapBuffer.position();
    }

    @Override
    public void setAppendPosition(long newPosition) {
        this._mmapBuffer.position((int)newPosition);
    }

    @Override
    public int appendInt(int value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._mmapBuffer.position();
            this._mmapBuffer.putInt(value);
            this.incrLoadSize(4);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int appendLong(long value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._mmapBuffer.position();
            this._mmapBuffer.putLong(value);
            this.incrLoadSize(8);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int appendShort(short value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._mmapBuffer.position();
            this._mmapBuffer.putShort(value);
            this.incrLoadSize(2);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int append(byte[] data) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._mmapBuffer.position();
            this._mmapBuffer.put(data, 0, data.length);
            this.incrLoadSize(data.length);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int append(byte[] data, int offset, int length) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._mmapBuffer.position();
            this._mmapBuffer.put(data, offset, length);
            this.incrLoadSize(length);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int readInt(int pos) {
        return this._mmapBuffer.getInt(pos);
    }

    @Override
    public long readLong(int pos) {
        return this._mmapBuffer.getLong(pos);
    }

    @Override
    public short readShort(int pos) {
        return this._mmapBuffer.getShort(pos);
    }

    @Override
    public void read(int pos, byte[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = this._mmapBuffer.get(pos + i);
        }
    }

    @Override
    public void read(int pos, byte[] dst, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = this._mmapBuffer.get(pos + i);
        }
    }

    @Override
    public int transferTo(int pos, int length, Segment targetSegment) throws IOException {
        if ((long)(pos + length) <= this._initSizeBytes) {
            byte[] dst = new byte[length];
            this.read(pos, dst);
            targetSegment.append(dst);
            return length;
        }
        throw new SegmentOverflowException(this, SegmentOverflowException.Type.READ_OVERFLOW);
    }

    @Override
    public int transferTo(int pos, int length, WritableByteChannel targetChannel) throws IOException {
        return (int)this._channel.transferTo(pos, length, targetChannel);
    }

    @Override
    public synchronized void asReadOnly() throws IOException {
        if (this.getMode() == Segment.Mode.READ_WRITE) {
            this.force();
            this._segMode = Segment.Mode.READ_ONLY;
            _log.info((Object)("Segment " + this.getSegmentId() + " switched to " + (Object)((Object)this.getMode())));
        }
    }

    @Override
    public synchronized void force() {
        if (this.getMode() == Segment.Mode.READ_WRITE) {
            this._lastForcedTime = System.currentTimeMillis();
            this._mmapBuffer.putLong(0, this._lastForcedTime);
        }
        this._mmapBuffer.force();
        _log.info((Object)("Segment " + this.getSegmentId() + " forced: " + this.getStatus()));
    }

    @Override
    public synchronized void close(boolean force) throws IOException {
        if (force) {
            this.force();
            this._channel.force(true);
        }
        if (this._channel != null) {
            this._channel.close();
            this._channel = null;
        }
        if (this._raf != null) {
            this._raf.close();
            this._raf = null;
        }
    }

    @Override
    public void reinit() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("reinit not supported");
    }

    @Override
    public boolean isRecyclable() {
        return false;
    }

    @Override
    public boolean canReadFromBuffer() {
        return false;
    }

    @Override
    public boolean canAppendToBuffer() {
        return false;
    }
}

