/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import krati.core.segment.SegmentIndexBufferException;

public class SegmentIndexBuffer
implements Cloneable {
    protected int _segId;
    protected long _lastForcedTime;
    protected ByteBuffer _buffer;
    private volatile boolean _dirty = false;
    public static final int HEADER_LENGTH = 16;
    public static final int FOOTER_LENGTH = 16;
    static final int MD5_LENGTH = 16;
    static final int HEADER_FOOTER_LENGTH = 32;
    static final int DEFAULT_CAPACITY = 1024;

    public SegmentIndexBuffer() {
        this._buffer = ByteBuffer.allocate(8192);
    }

    public SegmentIndexBuffer(int initialCapacity) {
        if (initialCapacity < 1) {
            initialCapacity = 1024;
        }
        this._buffer = ByteBuffer.allocate(initialCapacity << 3);
    }

    public int getSegmentId() {
        return this._segId;
    }

    public void setSegmentId(int segId) {
        this._segId = segId;
    }

    public long getSegmentLastForcedTime() {
        return this._lastForcedTime;
    }

    public void setSegmentLastForcedTime(long lastForcedTime) {
        this._lastForcedTime = lastForcedTime;
    }

    public int size() {
        return this._buffer.position() >> 3;
    }

    public int capacity() {
        return this._buffer.capacity() >> 3;
    }

    public void add(int index, int offset) {
        this.ensureCapacity();
        this._buffer.putInt(index);
        this._buffer.putInt(offset);
    }

    public void add(IndexOffset reuse) {
        this.ensureCapacity();
        this._buffer.putInt(reuse.getIndex());
        this._buffer.putInt(reuse.getOffset());
    }

    public IndexOffset get(int pos) {
        int i = pos << 3;
        int index = this._buffer.getInt(i);
        int offset = this._buffer.getInt(i + 4);
        return new IndexOffset(index, offset);
    }

    public void get(int pos, IndexOffset reuse) {
        int i = pos << 3;
        int index = this._buffer.getInt(i);
        int offset = this._buffer.getInt(i + 4);
        reuse.reinit(index, offset);
    }

    public int read(ReadableByteChannel channel) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(16);
        this.read(channel, header, 16, "Invalid Header");
        int segmentId = header.getInt(0);
        long lastForcedTime = header.getLong(4);
        int size = header.getInt(12);
        int dataLength = size << 3;
        ByteBuffer data = ByteBuffer.allocate(dataLength);
        this.read(channel, data, dataLength, "Invalid Data");
        ByteBuffer md5 = ByteBuffer.allocate(16);
        this.read(channel, md5, 16, "Invalid MD5");
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.reset();
            m.update(header.array());
            m.update(data.array());
            byte[] digest = this.ensure128BitMD5(m.digest());
            if (Arrays.equals(md5.array(), digest)) {
                this.setSegmentId(segmentId);
                this.setSegmentLastForcedTime(lastForcedTime);
                data.flip();
                this.put(data);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        return dataLength + 32;
    }

    public int read(ReadableByteChannel channel, long sibLastForcedTime) throws IOException, SegmentIndexBufferException {
        ByteBuffer header = ByteBuffer.allocate(16);
        this.read(channel, header, 16, "Invalid Header");
        int segmentId = header.getInt(0);
        long lastForcedTime = header.getLong(4);
        int size = header.getInt(12);
        if (lastForcedTime != sibLastForcedTime) {
            throw SegmentIndexBufferException.createObsolete(segmentId, lastForcedTime, sibLastForcedTime);
        }
        int dataLength = size << 3;
        ByteBuffer data = ByteBuffer.allocate(dataLength);
        this.read(channel, data, dataLength, "Invalid Data");
        ByteBuffer md5 = ByteBuffer.allocate(16);
        this.read(channel, md5, 16, "Invalid MD5");
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.reset();
            m.update(header.array());
            m.update(data.array());
            byte[] digest = this.ensure128BitMD5(m.digest());
            if (Arrays.equals(md5.array(), digest)) {
                this.setSegmentId(segmentId);
                this.setSegmentLastForcedTime(lastForcedTime);
                data.flip();
                this.put(data);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        return dataLength + 32;
    }

    public int write(WritableByteChannel channel) throws IOException {
        ByteBuffer footer;
        ByteBuffer header = ByteBuffer.allocate(16);
        header.putInt(this.getSegmentId());
        header.putLong(this.getSegmentLastForcedTime());
        header.putInt(this.size());
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.reset();
            m.update(header.array());
            m.update(this._buffer.array(), 0, this._buffer.position());
            byte[] digest = this.ensure128BitMD5(m.digest());
            footer = ByteBuffer.allocate(16);
            footer.put(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        header.flip();
        channel.write(header);
        channel.write(ByteBuffer.wrap(this._buffer.array(), 0, this._buffer.position()));
        footer.flip();
        channel.write(footer);
        return this._buffer.position() + 32;
    }

    protected void read(ReadableByteChannel channel, ByteBuffer bb, int expected, String message) throws IOException {
        int len = channel.read(bb);
        if (len != expected) {
            throw new IOException(message);
        }
    }

    protected byte[] ensure128BitMD5(byte[] digest) {
        if (digest.length == 16) {
            return digest;
        }
        if (digest.length > 16) {
            byte[] b = new byte[16];
            System.arraycopy(digest, 0, b, 0, 16);
            return b;
        }
        byte[] b = new byte[16];
        System.arraycopy(digest, 0, b, 0, digest.length);
        Arrays.fill(b, digest.length, b.length, (byte)0);
        return b;
    }

    protected void ensureCapacity() {
        if (this._buffer.remaining() < 8) {
            ByteBuffer b = ByteBuffer.allocate(this._buffer.capacity() << 1);
            this._buffer.flip();
            b.put(this._buffer);
            this._buffer = b;
        }
    }

    protected void put(ByteBuffer bb) {
        if (this._buffer.remaining() < bb.remaining()) {
            int newCapacity = Math.max(this._buffer.capacity() << 1, this._buffer.position() + bb.remaining());
            ByteBuffer b = ByteBuffer.allocate(newCapacity);
            this._buffer.flip();
            b.put(this._buffer);
            this._buffer = b;
        }
        this._buffer.put(bb);
    }

    protected ByteBuffer getByteBuffer() {
        return this._buffer;
    }

    public void clear() {
        this._buffer.clear();
    }

    public SegmentIndexBuffer clone() {
        SegmentIndexBuffer sib = new SegmentIndexBuffer(this.size());
        sib._buffer.put(this._buffer.array(), 0, this._buffer.position());
        sib.setSegmentId(this._segId);
        sib.setSegmentLastForcedTime(this._lastForcedTime);
        sib.setDirty(this._dirty);
        return sib;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean b) {
        this._dirty = b;
    }

    public void markAsClean() {
        this._dirty = false;
    }

    public void markAsDirty() {
        this._dirty = true;
    }

    public static class IndexOffset {
        private int _index;
        private int _offset;

        public IndexOffset() {
        }

        public IndexOffset(int index, int offset) {
            this._index = index;
            this._offset = offset;
        }

        public void reinit(int index, int offset) {
            this._index = index;
            this._offset = offset;
        }

        public void setIndex(int index) {
            this._index = index;
        }

        public int getIndex() {
            return this._index;
        }

        public void setOffset(int offset) {
            this._offset = offset;
        }

        public int getOffset() {
            return this._offset;
        }
    }
}

