/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import krati.core.segment.SegmentIndexBuffer;
import krati.core.segment.SegmentIndexBufferException;
import krati.core.segment.SegmentIndexBufferIO;
import org.apache.log4j.Logger;

public class SegmentIndexBufferFileIO
implements SegmentIndexBufferIO {
    private static final Logger _logger = Logger.getLogger(SegmentIndexBufferFileIO.class);
    public static final int STORAGE_VERSION = 1;
    public static final int STORAGE_VERSION_LENGTH = 4;

    @Override
    public int read(SegmentIndexBuffer sib, File sibFile) throws IOException {
        this.check(sibFile);
        RandomAccessFile raf = new RandomAccessFile(sibFile, "r");
        FileChannel channel = raf.getChannel();
        this.readVersion(channel);
        int length = sib.read(channel);
        length += 4;
        channel.close();
        raf.close();
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)("read " + sibFile.getAbsolutePath()));
        }
        return length;
    }

    @Override
    public int read(SegmentIndexBuffer sib, File sibFile, long sibLastForcedTime) throws IOException, SegmentIndexBufferException {
        this.check(sibFile);
        RandomAccessFile raf = new RandomAccessFile(sibFile, "r");
        FileChannel channel = raf.getChannel();
        this.readVersion(channel);
        int length = sib.read(channel, sibLastForcedTime);
        length += 4;
        channel.close();
        raf.close();
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)("read " + sibFile.getAbsolutePath()));
        }
        return length;
    }

    @Override
    public int write(SegmentIndexBuffer sib, File sibFile) throws IOException {
        this.create(sibFile);
        RandomAccessFile raf = new RandomAccessFile(sibFile, "rw");
        FileChannel channel = raf.getChannel();
        this.writeVersion(channel);
        int length = sib.write(channel);
        raf.setLength(length += 4);
        channel.force(true);
        channel.close();
        raf.close();
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)("write " + sibFile.getAbsolutePath()));
        }
        return length;
    }

    protected int readVersion(ReadableByteChannel channel) throws IOException {
        ByteBuffer version = ByteBuffer.allocate(4);
        int len = channel.read(version);
        if (len < 4) {
            throw new IOException("Invalid Version");
        }
        return version.getInt(0);
    }

    protected void writeVersion(WritableByteChannel channel) throws IOException {
        ByteBuffer version = ByteBuffer.allocate(4);
        version.putInt(1);
        version.flip();
        channel.write(version);
    }

    protected void create(File file) throws IOException {
        if (!file.exists()) {
            File dir = file.getParentFile();
            if (dir.exists()) {
                file.createNewFile();
            } else if (dir.mkdirs()) {
                file.createNewFile();
            } else {
                throw new IOException("Failed to create " + file.getAbsolutePath());
            }
        }
        if (file.isDirectory()) {
            throw new IOException("Cannot open directory " + file.getAbsolutePath());
        }
    }

    protected void check(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IOException("Cannot open directory " + file.getAbsolutePath());
        }
    }
}

