/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import krati.core.segment.SegmentIndexBuffer;
import krati.core.segment.SegmentIndexBufferFileIO;
import krati.core.segment.SegmentIndexBufferIO;

public class SegmentIndexBufferManager {
    protected final ConcurrentLinkedQueue<SegmentIndexBuffer> _sibSubmit;
    protected final ConcurrentHashMap<Integer, SegmentIndexBuffer> _sibLookup = new ConcurrentHashMap();
    private volatile SegmentIndexBufferIO _sibIO;

    public SegmentIndexBufferManager() {
        this._sibSubmit = new ConcurrentLinkedQueue();
        this.setSegmentIndexBufferIO(new SegmentIndexBufferFileIO());
    }

    public SegmentIndexBuffer getSegmentIndexBuffer(int segId) {
        return this._sibLookup.get(segId);
    }

    public SegmentIndexBuffer openSegmentIndexBuffer(int segId) {
        SegmentIndexBuffer sib = this._sibLookup.get(segId);
        if (sib == null) {
            sib = new SegmentIndexBuffer();
            sib.setSegmentId(segId);
            this._sibLookup.put(segId, sib);
        }
        return sib;
    }

    public boolean remove(SegmentIndexBuffer sib) {
        if (sib == null) {
            return false;
        }
        this._sibLookup.remove(sib.getSegmentId());
        return true;
    }

    public boolean submit(SegmentIndexBuffer sib) {
        if (sib == null) {
            return false;
        }
        this._sibLookup.remove(sib.getSegmentId());
        return this._sibSubmit.offer(sib);
    }

    public SegmentIndexBuffer poll() {
        return this._sibSubmit.poll();
    }

    public void clear() {
        this._sibLookup.clear();
        this._sibSubmit.clear();
    }

    public SegmentIndexBufferIO getSegmentIndexBufferIO() {
        return this._sibIO;
    }

    public void setSegmentIndexBufferIO(SegmentIndexBufferIO sibIO) {
        if (sibIO == null) {
            throw new NullPointerException();
        }
        this._sibIO = sibIO;
    }
}

