/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import krati.core.segment.Segment;
import org.apache.log4j.Logger;

public final class SegmentMeta
implements Closeable {
    private static final Logger _log = Logger.getLogger(SegmentMeta.class);
    private static final int FREE_SEGMENT = 0;
    private static final int LIVE_SEGMENT = 1;
    private final int _segmentDataShift = 4;
    private final int _segmentDataStart = 16;
    private final int _bytesPerSegment = 16;
    private final int _bytesPerSection = 8;
    private final int _initialSegmentCount = 100;
    private final File _metaFile;
    private RandomAccessFile _raf;
    private MappedByteBuffer _mmapBuffer;
    private int _workingGeneration = 0;
    private int _workingSectionOffset = 0;
    private int _liveSegmentCount = 0;
    private int _totalSegmentCount = 0;

    public SegmentMeta(File file) throws IOException {
        this._metaFile = file;
        this.init();
    }

    private long getInitialSizeBytes() {
        return 1616L;
    }

    private void createBuffer() throws IOException {
        long bufferLength = this._raf.length();
        this._mmapBuffer = this._raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, bufferLength);
    }

    private void init() throws IOException {
        boolean newFile = false;
        if (!this._metaFile.exists()) {
            if (!this._metaFile.createNewFile()) {
                String msg = "Failed to create " + this._metaFile.getAbsolutePath();
                _log.error((Object)msg);
                throw new IOException(msg);
            }
            newFile = true;
        }
        this._raf = new RandomAccessFile(this._metaFile, "rw");
        if (newFile) {
            this._raf.setLength(this.getInitialSizeBytes());
            this._workingGeneration = 0;
            this._workingSectionOffset = 0;
            this._liveSegmentCount = 0;
            this._totalSegmentCount = 100;
            this.createBuffer();
            _log.info((Object)(this._metaFile.getCanonicalPath() + " created"));
        } else {
            this.createBuffer();
            this._workingSectionOffset = 0;
            int gen1 = this.readInt(this._workingSectionOffset);
            int cnt1 = this.readInt(this._workingSectionOffset + 4);
            int gen2 = this.readInt(this._workingSectionOffset + 8);
            int cnt2 = this.readInt(this._workingSectionOffset + 8 + 4);
            this._workingGeneration = Math.abs(gen1 - gen2) == 1 ? Math.max(gen1, gen2) : Math.min(gen1, gen2);
            if (this._workingGeneration == gen2) {
                this._workingSectionOffset += 8;
            }
            this._liveSegmentCount = this._workingGeneration == gen1 ? cnt1 : cnt2;
            this._totalSegmentCount = (int)(this._raf.length() - 16L) / 16;
            _log.info((Object)(this._metaFile.getCanonicalPath() + " loaded"));
        }
        _log.info((Object)("workingGeneration=" + this._workingGeneration + " liveSegmentCount=" + this._liveSegmentCount));
    }

    private void writeInt(int pos, int value) {
        this._mmapBuffer.putInt(pos, value);
    }

    private int readInt(int pos) {
        return this._mmapBuffer.getInt(pos);
    }

    public final File getMetaFile() {
        return this._metaFile;
    }

    public synchronized int countSegmentsInService() {
        return this._liveSegmentCount;
    }

    public synchronized boolean hasSegmentInService(int segmentId) {
        if (segmentId < this._totalSegmentCount) {
            int pos = 16 + (segmentId << 4) + this._workingSectionOffset;
            return 1 == this.readInt(pos);
        }
        return false;
    }

    public synchronized int getSegmentLoadSize(int segmentId) {
        if (segmentId < this._totalSegmentCount) {
            int pos = 16 + (segmentId << 4) + this._workingSectionOffset;
            return this.readInt(pos + 4);
        }
        return 0;
    }

    public synchronized int getCapacity() {
        return this._totalSegmentCount;
    }

    public synchronized void ensureCapacity(int segmentCount) throws IOException {
        long newLength;
        long oldLength = this._raf.length();
        if (oldLength < (newLength = (long)(16 + segmentCount * 16))) {
            this._raf.setLength(newLength);
            this.createBuffer();
            this._totalSegmentCount = segmentCount;
        }
    }

    public synchronized void wrap(List<Segment> segments) throws IOException {
        int index;
        int newWorkingGeneration = (this._workingGeneration + 1) % Integer.MAX_VALUE;
        int newWorkingSectionOffset = (this._workingSectionOffset + 8) % 16;
        int cnt = segments.size();
        int pos = 16 + newWorkingSectionOffset;
        this.ensureCapacity(cnt);
        int newLiveSegmentCount = 0;
        for (index = 0; index < cnt; ++index) {
            if (segments.get(index) == null) continue;
            ++newLiveSegmentCount;
        }
        for (index = 0; index < cnt; ++index) {
            Segment seg = segments.get(index);
            if (seg != null) {
                if (seg.getLoadSize() > 0) {
                    this.writeInt(pos, 1);
                    this.writeInt(pos + 4, seg.getLoadSize());
                } else {
                    this.writeInt(pos, 0);
                    this.writeInt(pos + 4, 0);
                    --newLiveSegmentCount;
                }
            } else {
                this.writeInt(pos, 0);
                this.writeInt(pos + 4, 0);
            }
            pos += 16;
        }
        this._mmapBuffer.force();
        this.writeInt(newWorkingSectionOffset, newWorkingGeneration);
        this.writeInt(newWorkingSectionOffset + 4, newLiveSegmentCount);
        this._mmapBuffer.force();
        this._liveSegmentCount = newLiveSegmentCount;
        this._workingGeneration = newWorkingGeneration;
        this._workingSectionOffset = newWorkingSectionOffset;
        _log.info((Object)(this._metaFile.getCanonicalPath() + " updated"));
        _log.info((Object)("workingGeneration=" + this._workingGeneration + " liveSegmentCount=" + this._liveSegmentCount));
    }

    @Override
    public synchronized void close() throws IOException {
        this._raf.close();
        this._raf = null;
    }
}

