/*
 * Decompiled with CFR 0.152.
 */
package krati.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import krati.io.BasicIO;
import krati.io.DataWriter;

public class MultiMappedWriter
implements DataWriter,
BasicIO {
    private final File _file;
    private long _currentPosition;
    private FileChannel _channel;
    private RandomAccessFile _raf;
    private MappedByteBuffer[] _mmapArray;
    public static final int BUFFER_BITS = 30;
    public static final int BUFFER_SIZE = 0x40000000;
    public static final long BUFFER_MASK = 0x3FFFFFFFL;

    public MultiMappedWriter(File file) {
        this._file = file;
        this._currentPosition = 0L;
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public void open() throws IOException {
        if (!this._file.exists()) {
            File dir = this._file.getParentFile();
            if (dir.exists()) {
                this._file.createNewFile();
            } else if (dir.mkdirs()) {
                this._file.createNewFile();
            } else {
                throw new IOException("Failed to create file " + this._file.getAbsolutePath());
            }
        }
        if (this._file.isDirectory()) {
            throw new IOException("Cannot open directory " + this._file.getAbsolutePath());
        }
        this._raf = new RandomAccessFile(this._file, "rw");
        this._channel = this._raf.getChannel();
        int cnt = 0;
        long position = 0L;
        cnt = (int)(this._raf.length() >> 30);
        this._mmapArray = new MappedByteBuffer[cnt += (this._raf.length() & 0x3FFFFFFFL) > 0L ? 1 : 0];
        for (int i = 0; i < cnt; ++i) {
            long size = Math.min(this._raf.length() - position, 0x40000000L);
            this._mmapArray[i] = this._channel.map(FileChannel.MapMode.READ_WRITE, position, size);
            position += 0x40000000L;
        }
        this._currentPosition = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this._mmapArray != null) {
                for (MappedByteBuffer b : this._mmapArray) {
                    if (b == null) continue;
                    b.force();
                }
            }
            if (this._channel != null) {
                this._channel.force(true);
                this._channel.close();
            }
            if (this._raf != null) {
                this._raf.close();
            }
        }
        finally {
            this._currentPosition = 0L;
            this._mmapArray = null;
            this._channel = null;
            this._raf = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this._channel.force(true);
    }

    @Override
    public void force() throws IOException {
        for (MappedByteBuffer b : this._mmapArray) {
            if (b == null) continue;
            b.force();
        }
        this._channel.force(true);
    }

    @Override
    public void writeInt(int value) throws IOException {
        int pos = (int)(this._currentPosition & 0x3FFFFFFFL);
        int ind = (int)(this._currentPosition >> 30);
        this._mmapArray[ind].putInt(pos, value);
        this._currentPosition += 4L;
    }

    @Override
    public void writeLong(long value) throws IOException {
        int pos = (int)(this._currentPosition & 0x3FFFFFFFL);
        int ind = (int)(this._currentPosition >> 30);
        this._mmapArray[ind].putLong(pos, value);
        this._currentPosition += 8L;
    }

    @Override
    public void writeShort(short value) throws IOException {
        int pos = (int)(this._currentPosition & 0x3FFFFFFFL);
        int ind = (int)(this._currentPosition >> 30);
        this._mmapArray[ind].putShort(pos, value);
        this._currentPosition += 2L;
    }

    @Override
    public void writeInt(long position, int value) throws IOException {
        int pos = (int)(position & 0x3FFFFFFFL);
        int ind = (int)(position >> 30);
        this._mmapArray[ind].putInt(pos, value);
    }

    @Override
    public void writeLong(long position, long value) throws IOException {
        int pos = (int)(position & 0x3FFFFFFFL);
        int ind = (int)(position >> 30);
        this._mmapArray[ind].putLong(pos, value);
    }

    @Override
    public void writeShort(long position, short value) throws IOException {
        int pos = (int)(position & 0x3FFFFFFFL);
        int ind = (int)(position >> 30);
        this._mmapArray[ind].putShort(pos, value);
    }

    @Override
    public long position() throws IOException {
        return this._currentPosition;
    }

    @Override
    public void position(long newPosition) throws IOException {
        int i;
        int pos = (int)(newPosition & 0x3FFFFFFFL);
        int ind = (int)(newPosition >> 30);
        for (i = 0; i < ind; ++i) {
            this._mmapArray[i].position(0x3FFFFFFF);
        }
        this._mmapArray[ind].position(pos);
        for (i = ind; i < this._mmapArray.length; ++i) {
            this._mmapArray[i].clear();
        }
        this._currentPosition = newPosition;
    }

    @Override
    public int readInt(long position) throws IOException {
        int pos = (int)(position & 0x3FFFFFFFL);
        int ind = (int)(position >> 30);
        return this._mmapArray[ind].getInt(pos);
    }

    @Override
    public long readLong(long position) throws IOException {
        int pos = (int)(position & 0x3FFFFFFFL);
        int ind = (int)(position >> 30);
        return this._mmapArray[ind].getLong(pos);
    }

    @Override
    public short readShort(long position) throws IOException {
        int pos = (int)(position & 0x3FFFFFFFL);
        int ind = (int)(position >> 30);
        return this._mmapArray[ind].getShort(pos);
    }

    public void remap() throws IOException {
        long mappedLength;
        if (this._mmapArray == null) {
            this.open();
            return;
        }
        long length = this._raf.length();
        if (length != (mappedLength = this.getMappedLength())) {
            int i;
            for (int i2 = 0; i2 < this._mmapArray.length; ++i2) {
                this._mmapArray[i2].force();
            }
            int cnt = 0;
            long position = 0L;
            cnt = (int)(length >> 30);
            MappedByteBuffer[] mmapArray = new MappedByteBuffer[cnt += (length & 0x3FFFFFFFL) > 0L ? 1 : 0];
            int sharedCnt = Math.min(mmapArray.length, this._mmapArray.length) - 1;
            for (i = 0; i < sharedCnt; ++i) {
                mmapArray[i] = this._mmapArray[i];
                position += 0x40000000L;
            }
            for (i = sharedCnt; i < cnt; ++i) {
                long size = Math.min(length - position, 0x40000000L);
                mmapArray[i] = this._channel.map(FileChannel.MapMode.READ_WRITE, position, size);
                position += 0x40000000L;
            }
            this._mmapArray = mmapArray;
            this._currentPosition = 0L;
        }
    }

    public final long getMappedLength() {
        MappedByteBuffer[] mmapArray = this._mmapArray;
        long length = 0L;
        if (mmapArray != null) {
            for (MappedByteBuffer mmap : mmapArray) {
                length += (long)mmap.capacity();
            }
        }
        return length;
    }
}

