/*
 * Decompiled with CFR 0.152.
 */
package krati.io.serializer;

import java.nio.ByteOrder;
import krati.io.SerializationException;
import krati.io.Serializer;
import krati.util.Numbers;

public class DoubleSerializer
implements Serializer<Double> {
    private final ByteOrder _byteOrder;

    public DoubleSerializer() {
        this._byteOrder = ByteOrder.BIG_ENDIAN;
    }

    public DoubleSerializer(ByteOrder byteOrder) {
        this._byteOrder = byteOrder == null ? ByteOrder.BIG_ENDIAN : byteOrder;
    }

    @Override
    public byte[] serialize(Double value) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.doubleBytesBE(value) : Numbers.doubleBytesLE(value);
    }

    @Override
    public Double deserialize(byte[] bytes) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.doubleValueBE(bytes) : Numbers.doubleValueLE(bytes);
    }

    public double doubleValue(byte[] bytes) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.doubleValueBE(bytes) : Numbers.doubleValueLE(bytes);
    }

    public byte[] doubleBytes(double value) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.doubleBytesBE(value) : Numbers.doubleBytesLE(value);
    }
}

