/*
 * Decompiled with CFR 0.152.
 */
package krati.io.serializer;

import java.nio.ByteOrder;
import krati.io.SerializationException;
import krati.io.Serializer;
import krati.util.Numbers;

public class FloatSerializer
implements Serializer<Float> {
    private final ByteOrder _byteOrder;

    public FloatSerializer() {
        this._byteOrder = ByteOrder.BIG_ENDIAN;
    }

    public FloatSerializer(ByteOrder byteOrder) {
        this._byteOrder = byteOrder == null ? ByteOrder.BIG_ENDIAN : byteOrder;
    }

    @Override
    public byte[] serialize(Float value) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.floatBytesBE(value.floatValue()) : Numbers.floatBytesLE(value.floatValue());
    }

    @Override
    public Float deserialize(byte[] bytes) throws SerializationException {
        return Float.valueOf(this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.floatValueBE(bytes) : Numbers.floatValueLE(bytes));
    }

    public float floatValue(byte[] bytes) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.floatValueBE(bytes) : Numbers.floatValueLE(bytes);
    }

    public byte[] floatBytes(float value) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.floatBytesBE(value) : Numbers.floatBytesLE(value);
    }
}

