/*
 * Decompiled with CFR 0.152.
 */
package krati.io.serializer;

import java.nio.ByteOrder;
import krati.io.SerializationException;
import krati.io.Serializer;
import krati.util.Numbers;

public class ShortSerializer
implements Serializer<Short> {
    private final ByteOrder _byteOrder;

    public ShortSerializer() {
        this._byteOrder = ByteOrder.BIG_ENDIAN;
    }

    public ShortSerializer(ByteOrder byteOrder) {
        this._byteOrder = byteOrder == null ? ByteOrder.BIG_ENDIAN : byteOrder;
    }

    @Override
    public byte[] serialize(Short value) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.shortBytesBE(value.shortValue()) : Numbers.shortBytesLE(value);
    }

    @Override
    public Short deserialize(byte[] bytes) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.shortValueBE(bytes) : Numbers.shortValueLE(bytes);
    }

    public short shortValue(byte[] bytes) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.shortValueBE(bytes) : Numbers.shortValueLE(bytes);
    }

    public byte[] shortBytes(Short value) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.shortBytesBE(value.shortValue()) : Numbers.shortBytesLE(value);
    }
}

