/*
 * Decompiled with CFR 0.152.
 */
package krati.retention;

import java.io.File;
import krati.core.segment.SegmentFactory;
import krati.core.segment.WriteBufferSegmentFactory;
import krati.io.Serializer;
import krati.retention.clock.Clock;
import krati.retention.policy.RetentionPolicy;
import krati.retention.policy.RetentionPolicyOnSize;

public class RetentionConfig<T> {
    private int _id;
    private File _homeDir;
    private int _batchSize = 10000;
    private int _numSyncBatchs = 10;
    private int _retentionInitialSize = 10000;
    private int _retentionSegmentFileSizeMB = 32;
    private SegmentFactory _retentionSegmentFactory = new WriteBufferSegmentFactory();
    private RetentionPolicy _retentionPolicy = new RetentionPolicyOnSize(1000);
    private Serializer<T> _eventValueSerializer;
    private Serializer<Clock> _eventClockSerializer;
    private static final int RETENTION_INITIAL_SIZE_MIN = 1000;
    private static final int RETENTION_INITIAL_SIZE_DEFAULT = 10000;

    public RetentionConfig(int id, File homeDir) {
        this._id = id;
        this._homeDir = homeDir;
    }

    public int getId() {
        return this._id;
    }

    public File getHomeDir() {
        return this._homeDir;
    }

    public void setRetentionInitialSize(int retentionInitialSize) {
        this._retentionInitialSize = Math.max(1000, retentionInitialSize);
    }

    public int getRetentionInitialSize() {
        return this._retentionInitialSize;
    }

    public void setRetentionSegmentFileSizeMB(int retentionSegmentFileSizeMB) {
        this._retentionSegmentFileSizeMB = Math.max(8, retentionSegmentFileSizeMB);
    }

    public int getRetentionSegmentFileSizeMB() {
        return this._retentionSegmentFileSizeMB;
    }

    public void setRetentionSegmentFactory(SegmentFactory retentionSegmentFactory) {
        this._retentionSegmentFactory = retentionSegmentFactory == null ? new WriteBufferSegmentFactory() : retentionSegmentFactory;
    }

    public SegmentFactory getRetentionSegmentFactory() {
        return this._retentionSegmentFactory;
    }

    public void setBatchSize(int batchSize) {
        this._batchSize = Math.max(100, batchSize);
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public void setNumSyncBatchs(int numSyncBatchs) {
        this._numSyncBatchs = numSyncBatchs;
    }

    public int getNumSyncBatchs() {
        return this._numSyncBatchs;
    }

    public void setRetentionPolicy(RetentionPolicy retentionPolicy) {
        this._retentionPolicy = retentionPolicy;
    }

    public RetentionPolicy getRetentionPolicy() {
        return this._retentionPolicy;
    }

    public void setEventValueSerializer(Serializer<T> eventValueSerializer) {
        this._eventValueSerializer = eventValueSerializer;
    }

    public Serializer<T> getEventValueSerializer() {
        return this._eventValueSerializer;
    }

    public void setEventClockSerializer(Serializer<Clock> eventClockSerializer) {
        this._eventClockSerializer = eventClockSerializer;
    }

    public Serializer<Clock> getEventClockSerializer() {
        return this._eventClockSerializer;
    }
}

