/*
 * Decompiled with CFR 0.152.
 */
package krati.retention;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import krati.retention.Event;
import krati.retention.EventBatch;
import krati.retention.EventBatchHeader;
import krati.retention.SimpleEventBatchHeader;
import krati.retention.clock.Clock;
import krati.retention.clock.Occurred;

public final class SimpleEventBatch<T>
implements EventBatch<T>,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final long _origin;
    private final int _capacity;
    private volatile Clock _minClock;
    private volatile Clock _maxClock;
    private volatile long _creationTime;
    private volatile long _completionTime;
    private final ArrayList<Event<T>> _events;

    public SimpleEventBatch(long origin, Clock initClock) {
        this(origin, initClock, 10000);
    }

    public SimpleEventBatch(long origin, Clock initClock, int capacity) {
        this._origin = origin;
        this._minClock = initClock;
        this._maxClock = initClock;
        this._capacity = Math.max(100, capacity);
        this._events = new ArrayList(this._capacity);
        this._creationTime = System.currentTimeMillis();
        this._completionTime = System.currentTimeMillis();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public int getSize() {
        return this._events.size();
    }

    @Override
    public long getOrigin() {
        return this._origin;
    }

    @Override
    public long getCreationTime() {
        return this._creationTime;
    }

    @Override
    public void setCreationTime(long time) {
        this._creationTime = time;
    }

    @Override
    public long getCompletionTime() {
        return this._completionTime;
    }

    @Override
    public void setCompletionTime(long time) {
        this._completionTime = time;
    }

    @Override
    public Clock getMinClock() {
        return this._minClock;
    }

    @Override
    public Clock getMaxClock() {
        return this._maxClock;
    }

    @Override
    public Iterator<Event<T>> iterator() {
        return this._events.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this._events.isEmpty();
    }

    @Override
    public boolean isFull() {
        return this._events.size() >= this._capacity;
    }

    @Override
    public EventBatchHeader getHeader() {
        return new SimpleEventBatchHeader(this.getVersion(), this.getSize(), this.getOrigin(), this.getCreationTime(), this.getCompletionTime(), this.getMinClock(), this.getMaxClock());
    }

    @Override
    public Clock getClock(long offset) {
        if (this._origin <= offset && offset < this._origin + (long)this._events.size()) {
            return this._events.get((int)(offset - this._origin)).getClock();
        }
        if (this._origin == offset) {
            return this._minClock;
        }
        return null;
    }

    @Override
    public long getOffset(Clock sinceClock) {
        if (this._minClock.before(sinceClock) && !sinceClock.after(this._maxClock)) {
            Event<T> e;
            Occurred occ;
            int i;
            for (i = 0; i < this._events.size() && (occ = sinceClock.compareTo((e = this._events.get(i)).getClock())) != Occurred.EQUICONCURRENTLY; ++i) {
                if (occ != Occurred.BEFORE && occ != Occurred.CONCURRENTLY) continue;
                --i;
                break;
            }
            return this._origin + (long)i;
        }
        return -1L;
    }

    @Override
    public boolean put(Event<T> event) {
        Clock clock = event.getClock();
        int size = this._events.size();
        if (size == 0 && this._minClock.before(clock)) {
            this._minClock = clock;
            this._maxClock = clock;
        }
        if (size < this._capacity && this._maxClock.beforeEqual(clock)) {
            this._events.add(event);
            this._maxClock = clock;
            return true;
        }
        return false;
    }

    @Override
    public long get(long offset, List<Event<T>> list) {
        return this.get(offset, Integer.MAX_VALUE, list);
    }

    @Override
    public long get(long offset, int count, List<Event<T>> list) {
        int ind = (int)(offset - this.getOrigin());
        if (0 <= ind && ind < this._events.size()) {
            while (ind < this._events.size()) {
                Event<T> e = this._events.get(ind);
                list.add(e);
                if (0 == --count) {
                    return this.getOrigin() + (long)ind + 1L;
                }
                ++ind;
            }
            return this.getOrigin() + (long)ind;
        }
        return offset;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(SimpleEventBatch.class.getSimpleName()).append("{");
        b.append("version=").append(this.getVersion()).append(",");
        b.append("size=").append(this._events.size()).append(",");
        b.append("origin=").append(this._origin).append(",");
        b.append("creationTime=").append(this._creationTime).append(",");
        b.append("completionTime=").append(this._completionTime).append(",");
        b.append("minClock=").append(this._minClock).append(",");
        b.append("maxClock=").append(this._maxClock).append("}");
        return b.toString();
    }

    public SimpleEventBatch<T> clone() {
        SimpleEventBatch<T> batch = new SimpleEventBatch<T>(this.getOrigin(), this._minClock, this._capacity);
        batch._maxClock = this._maxClock;
        batch._events.addAll(this._events);
        batch._creationTime = this._creationTime;
        batch._completionTime = this._completionTime;
        return batch;
    }
}

