/*
 * Decompiled with CFR 0.152.
 */
package krati.retention;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import krati.io.SerializationException;
import krati.io.Serializer;
import krati.retention.Event;
import krati.retention.EventBatch;
import krati.retention.EventBatchHeader;
import krati.retention.EventBatchSerializer;
import krati.retention.SimpleEvent;
import krati.retention.SimpleEventBatch;
import krati.retention.SimpleEventBatchHeader;
import krati.retention.clock.Clock;

public class SimpleEventBatchSerializer<T>
implements EventBatchSerializer<T> {
    private final Serializer<T> _valueSerializer;
    private final Serializer<Clock> _clockSerializer;
    private static final int NUM_NON_CLOCK_BYTES_IN_HEADER = 34;

    public SimpleEventBatchSerializer(Serializer<T> valueSerializer, Serializer<Clock> clockSerializer) {
        this._valueSerializer = valueSerializer;
        this._clockSerializer = clockSerializer;
    }

    @Override
    public EventBatch<T> deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null) {
            return null;
        }
        EventBatchHeader header = this.deserializeHeader(bytes);
        int minClockLength = header.getMinClock().values().length << 3;
        int maxClockLength = header.getMaxClock().values().length << 3;
        int headerLength = 34 + minClockLength + maxClockLength;
        try {
            ByteBuffer buffer = ByteBuffer.wrap(bytes, headerLength, bytes.length - headerLength);
            SimpleEventBatch<T> batch = new SimpleEventBatch<T>(header.getOrigin(), header.getMinClock(), header.getSize());
            batch.setCreationTime(header.getCreationTime());
            batch.setCompletionTime(header.getCompletionTime());
            int size = header.getSize();
            for (int i = 0; i < size; ++i) {
                int length = buffer.getInt();
                byte[] valueBytes = new byte[length];
                buffer.get(valueBytes);
                T value = this._valueSerializer.deserialize(valueBytes);
                length = buffer.get();
                byte[] clockBytes = new byte[length];
                buffer.get(clockBytes);
                Clock clock = this._clockSerializer.deserialize(clockBytes);
                SimpleEvent<T> event = new SimpleEvent<T>(value, clock);
                if (batch.put(event)) continue;
                throw new SerializationException("Invalid clocks: clock=" + clock + " minClock=" + header.getMinClock() + " maxClock=" + header.getMaxClock());
            }
            return batch;
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("Failed to deserialize", e);
        }
    }

    @Override
    public byte[] serialize(EventBatch<T> object) throws SerializationException {
        if (object == null) {
            return null;
        }
        byte[] valueBytes = null;
        byte[] clockBytes = null;
        byte[] intBytes = new byte[4];
        byte[] clockLenByte = new byte[1];
        ByteBuffer bbInt = ByteBuffer.wrap(intBytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] headerBytes = this.serializeHeader(object);
        try {
            baos.write(headerBytes);
            for (Event<T> event : object) {
                T value = event.getValue();
                Clock clock = event.getClock();
                valueBytes = this._valueSerializer.serialize(value);
                bbInt.clear();
                bbInt.putInt(valueBytes.length);
                baos.write(intBytes);
                baos.write(valueBytes);
                clockBytes = this._clockSerializer.serialize(clock);
                clockLenByte[0] = (byte)clockBytes.length;
                baos.write(clockLenByte);
                baos.write(clockBytes);
            }
            return baos.toByteArray();
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("Failed to serialize", e);
        }
    }

    @Override
    public EventBatchHeader deserializeHeader(byte[] bytes) throws SerializationException {
        if (bytes == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        int version = bb.getInt();
        if (version < 0) {
            throw new SerializationException("Invalid version: " + version);
        }
        int size = bb.getInt();
        if (size < 0) {
            throw new SerializationException("Invalid size: " + size);
        }
        long origin = bb.getLong();
        long creationTime = bb.getLong();
        long completionTime = bb.getLong();
        byte length = bb.get();
        byte[] minClockBytes = new byte[length];
        bb.get(minClockBytes);
        Clock minClock = this._clockSerializer.deserialize(minClockBytes);
        length = bb.get();
        byte[] maxClockBytes = new byte[length];
        bb.get(maxClockBytes);
        Clock maxClock = this._clockSerializer.deserialize(maxClockBytes);
        return new SimpleEventBatchHeader(version, size, origin, creationTime, completionTime, minClock, maxClock);
    }

    @Override
    public byte[] serializeHeader(EventBatchHeader header) throws SerializationException {
        if (header == null) {
            return null;
        }
        byte[] minClockBytes = this._clockSerializer.serialize(header.getMinClock());
        byte[] maxClockBytes = this._clockSerializer.serialize(header.getMaxClock());
        byte[] byteArray = new byte[34 + minClockBytes.length + maxClockBytes.length];
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        bb.putInt(header.getVersion());
        bb.putInt(header.getSize());
        bb.putLong(header.getOrigin());
        bb.putLong(header.getCreationTime());
        bb.putLong(header.getCompletionTime());
        bb.put((byte)minClockBytes.length);
        bb.put(minClockBytes);
        bb.put((byte)maxClockBytes.length);
        bb.put(maxClockBytes);
        return byteArray;
    }
}

