/*
 * Decompiled with CFR 0.152.
 */
package krati.retention;

import krati.retention.Position;
import krati.retention.clock.Clock;

public class SimplePosition
implements Position {
    private static final long serialVersionUID = 1L;
    private int _id = -1;
    private long _offset = -1L;
    private int _index = -1;
    private Clock _clock;

    public SimplePosition(int id, long offset, Clock clock) {
        this(id, offset, -1, clock);
    }

    public SimplePosition(int id, long offset, int index, Clock clock) {
        this._id = id;
        this._offset = offset;
        this._index = index;
        this._clock = clock;
    }

    @Override
    public int getId() {
        return this._id;
    }

    @Override
    public long getOffset() {
        return this._offset;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public boolean isIndexed() {
        return this._index >= 0;
    }

    @Override
    public Clock getClock() {
        return this._clock;
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this._id).append(':').append(this._offset).append(':').append(this._index).append(':').append(this._clock);
        return b.toString();
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        SimplePosition p = (SimplePosition)o;
        return p._id == this._id && p._offset == this._offset && p._index == this._index && p._clock.equals(this._clock);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this._id;
        hash = 97 * hash + (int)this._offset;
        hash = 97 * hash + this._index;
        hash = 97 * hash + this._clock.hashCode();
        return hash;
    }

    public static SimplePosition parsePosition(String s) {
        String[] parts = s.split(":");
        int id = Integer.parseInt(parts[0]);
        long offset = Long.parseLong(parts[1]);
        int index = Integer.parseInt(parts[2]);
        if (parts.length == 3) {
            return new SimplePosition(id, offset, index, Clock.ZERO);
        }
        long[] values = new long[parts.length - 3];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Long.parseLong(parts[3 + i]);
        }
        return new SimplePosition(id, offset, index, new Clock(values));
    }
}

