/*
 * Decompiled with CFR 0.152.
 */
package krati.retention.clock;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import krati.retention.clock.IncomparableClocksException;
import krati.retention.clock.Occurred;

public final class Clock
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long[] _values;
    public static final Clock ZERO = new Clock(new long[0]);

    public Clock(long ... values) {
        this._values = values;
    }

    public long[] values() {
        return this._values;
    }

    public static Clock parseClock(String str) {
        if (str == null || str.length() == 0) {
            return ZERO;
        }
        String[] parts = str.split(":");
        long[] values = new long[parts.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Long.parseLong(parts[i]);
        }
        return new Clock(values);
    }

    public static Clock parseClock(byte[] raw) {
        if (raw == null || raw.length < 8) {
            return ZERO;
        }
        int cnt = raw.length >> 3;
        long[] values = new long[cnt];
        ByteBuffer bb = ByteBuffer.wrap(raw);
        for (int i = 0; i < values.length; ++i) {
            values[i] = bb.getLong();
        }
        return new Clock(values);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this._values != null && 1 <= this._values.length) {
            b.append(this._values[0]);
            for (int i = 1; i < this._values.length; ++i) {
                b.append(':').append(this._values[i]);
            }
        }
        return b.toString();
    }

    public byte[] toByteArray() {
        if (this._values != null) {
            byte[] byteArray = new byte[this._values.length << 3];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
            for (int i = 0; i < this._values.length; ++i) {
                byteBuffer.putLong(this._values[i]);
            }
            return byteArray;
        }
        return new byte[0];
    }

    public Occurred compareTo(Clock c) {
        if (this == c) {
            return Occurred.EQUICONCURRENTLY;
        }
        if (ZERO == c) {
            return Occurred.AFTER;
        }
        if (this == ZERO) {
            return Occurred.BEFORE;
        }
        int neg = 0;
        int pos = 0;
        int eq = 0;
        try {
            long[] dst = c.values();
            int len = dst.length;
            if (this._values.length == len) {
                for (int i = 0; i < len; ++i) {
                    long cmp = this._values[i] - dst[i];
                    if (cmp < 0L) {
                        ++neg;
                        continue;
                    }
                    if (cmp > 0L) {
                        ++pos;
                        continue;
                    }
                    ++eq;
                }
                if (eq == len) {
                    return Occurred.EQUICONCURRENTLY;
                }
                if (neg == len) {
                    return Occurred.BEFORE;
                }
                if (pos == len) {
                    return Occurred.AFTER;
                }
                if ((neg += eq) == len) {
                    return Occurred.BEFORE;
                }
                if ((pos += eq) == len) {
                    return Occurred.AFTER;
                }
                return Occurred.CONCURRENTLY;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new IncomparableClocksException(this, c);
    }

    public boolean before(Clock c) {
        return this.compareTo(c) == Occurred.BEFORE;
    }

    public boolean after(Clock c) {
        return this.compareTo(c) == Occurred.AFTER;
    }

    public boolean beforeEqual(Clock c) {
        Occurred o = this.compareTo(c);
        return o == Occurred.BEFORE || o == Occurred.EQUICONCURRENTLY;
    }

    public boolean afterEqual(Clock c) {
        Occurred o = this.compareTo(c);
        return o == Occurred.AFTER || o == Occurred.EQUICONCURRENTLY;
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Clock c = (Clock)o;
        return Arrays.equals(this._values, c._values);
    }

    public int hashCode() {
        return Arrays.hashCode(this._values);
    }
}

