/*
 * Decompiled with CFR 0.152.
 */
package krati.retention.clock;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import krati.retention.clock.Clock;
import krati.retention.clock.WaterMarksClock;
import krati.util.SourceWaterMarks;

public class SourceWaterMarksClock
implements WaterMarksClock {
    private final List<String> _sources;
    private final List<SourceWaterMarks.WaterMarkEntry> _entries;
    private final SourceWaterMarks _sourceWaterMarks;

    public SourceWaterMarksClock(List<String> sources, SourceWaterMarks sourceWaterMarks) {
        this._sources = sources;
        this._sourceWaterMarks = sourceWaterMarks;
        for (String source : sources) {
            long lwm = sourceWaterMarks.getLWMScn(source);
            long hwm = sourceWaterMarks.getHWMScn(source);
            sourceWaterMarks.setWaterMarks(source, lwm, hwm);
        }
        int size = this._sources.size();
        this._entries = new ArrayList<SourceWaterMarks.WaterMarkEntry>(size);
        for (int i = 0; i < size; ++i) {
            this._entries.add(sourceWaterMarks.getEntry(this._sources.get(i)));
        }
    }

    @Override
    public boolean hasSource(String source) {
        if (source == null) {
            return false;
        }
        for (String s : this._sources) {
            if (!s.equals(source)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<String> sourceIterator() {
        return this._sources.iterator();
    }

    @Override
    public synchronized Clock current() {
        int cnt = this._entries.size();
        long[] values = new long[cnt];
        for (int i = 0; i < cnt; ++i) {
            values[i] = this._entries.get(i).getHWMScn();
        }
        return new Clock(values);
    }

    @Override
    public synchronized long getLWMScn(String source) {
        return this._sourceWaterMarks.getLWMScn(source);
    }

    @Override
    public synchronized long getHWMScn(String source) {
        return this._sourceWaterMarks.getHWMScn(source);
    }

    @Override
    public synchronized void setHWMark(String source, long hwm) {
        this._sourceWaterMarks.saveHWMark(source, hwm);
    }

    @Override
    public synchronized Clock updateHWMark(String source, long hwm) {
        this._sourceWaterMarks.saveHWMark(source, hwm);
        return this.current();
    }

    @Override
    public synchronized Clock updateWaterMarks(String source, long lwm, long hwm) {
        this._sourceWaterMarks.setWaterMarks(source, lwm, hwm);
        return this.current();
    }

    @Override
    public synchronized Clock syncWaterMarks(String source) {
        this._sourceWaterMarks.syncWaterMarks(source);
        return this.current();
    }

    @Override
    public synchronized Clock syncWaterMarks() {
        this._sourceWaterMarks.syncWaterMarks();
        return this.current();
    }

    @Override
    public synchronized boolean flush() {
        return this._sourceWaterMarks.flush();
    }

    @Override
    public long getWaterMark(String source, Clock clock) {
        if (Clock.ZERO == clock) {
            return 0L;
        }
        int cnt = this._sources.size();
        for (int i = 0; i < cnt; ++i) {
            if (!source.equals(this._sources.get(i))) continue;
            return clock.values()[i];
        }
        throw new IllegalArgumentException("Unknown " + source);
    }
}

