/*
 * Decompiled with CFR 0.152.
 */
package krati.retention.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import krati.retention.EventBatch;
import krati.retention.EventBatchCursor;
import krati.retention.policy.RetentionPolicy;

public class RetentionPolicyOnSize
implements RetentionPolicy {
    private int _numRetentionBatches;

    public RetentionPolicyOnSize() {
        this(1000);
    }

    public RetentionPolicyOnSize(int numRetentionBatches) {
        this.setNumRetentionBatches(numRetentionBatches);
    }

    public final int getNumRetentionBatches() {
        return this._numRetentionBatches;
    }

    public final void setNumRetentionBatches(int numRetentionBatches) {
        this._numRetentionBatches = Math.max(1, numRetentionBatches);
    }

    @Override
    public synchronized Collection<EventBatchCursor> apply(ConcurrentLinkedQueue<EventBatchCursor> queue) {
        ArrayList<EventBatchCursor> results = new ArrayList<EventBatchCursor>();
        while (queue.size() > this.getNumRetentionBatches()) {
            EventBatchCursor c = queue.poll();
            if (c == null) continue;
            results.add(c);
        }
        return results;
    }

    @Override
    public void applyCallbackOn(EventBatch<?> batch) {
    }

    @Override
    public boolean isCallback() {
        return false;
    }
}

