/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import krati.array.DataArray;
import krati.store.DataStoreHandler;
import krati.util.IndexedIterator;

final class DataStoreKeyIterator
implements IndexedIterator<byte[]> {
    private final ArrayList<byte[]> _bucket;
    private final DataStoreHandler _dataHandler;
    private final DataArray _dataArray;
    private int _index = 0;

    DataStoreKeyIterator(DataArray dataArray, DataStoreHandler dataHandler) {
        this._dataArray = dataArray;
        this._dataHandler = dataHandler;
        this._bucket = new ArrayList(20);
        this.findNext();
    }

    @Override
    public boolean hasNext() {
        if (this._bucket.size() == 0) {
            this.findNext();
        }
        return this._bucket.size() > 0;
    }

    @Override
    public byte[] next() {
        int size = this._bucket.size();
        if (size == 0) {
            this.findNext();
            size = this._bucket.size();
        }
        if (size > 0) {
            return this._bucket.remove(--size);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void findNext() {
        while (this._index < this._dataArray.length()) {
            List<byte[]> keys;
            byte[] data;
            if ((data = this._dataArray.get(this._index++)) == null || (keys = this._dataHandler.extractKeys(data)) == null || keys.size() <= 0) continue;
            this._bucket.addAll(keys);
            break;
        }
    }

    @Override
    public int index() {
        return this._index;
    }

    @Override
    public void reset(int indexStart) {
        this._index = Math.max(0, indexStart);
        this._bucket.clear();
        this.findNext();
    }
}

