/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import krati.Mode;
import krati.PersistableListener;
import krati.array.DataArray;
import krati.core.StoreConfig;
import krati.core.StoreParams;
import krati.core.array.AddressArray;
import krati.core.array.AddressArrayFactory;
import krati.core.array.SimpleDataArray;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;
import krati.store.DataStore;
import krati.store.DataStoreHandler;
import krati.store.DataStoreIterator;
import krati.store.DataStoreKeyIterator;
import krati.store.DefaultDataStoreHandler;
import krati.store.StoreClosedException;
import krati.util.FnvHashFunction;
import krati.util.HashFunction;
import krati.util.IndexedIterator;
import krati.util.LinearHashing;
import org.apache.log4j.Logger;

public class DynamicDataStore
implements DataStore<byte[], byte[]> {
    private static final Logger _log = Logger.getLogger(DynamicDataStore.class);
    private final File _homeDir;
    private final StoreConfig _config;
    private final SimpleDataArray _dataArray;
    private final DataStoreHandler _dataHandler;
    private final HashFunction<byte[]> _hashFunction;
    private final double _loadThreshold;
    private final int _unitCapacity;
    private final int _maxLevel;
    private volatile int _split;
    private volatile int _level;
    private volatile int _levelCapacity;
    private volatile int _loadCount;
    private volatile int _loadCountThreshold;
    private long _scn;

    public DynamicDataStore(StoreConfig config) throws Exception {
        config.validate();
        config.save();
        this._config = config;
        this._homeDir = config.getHomeDir();
        this._dataHandler = config.getDataHandler() == null ? new DefaultDataStoreHandler() : (DataStoreHandler)config.getDataHandler();
        boolean found = this.isAddressArrayFound(this._config.getHomeDir());
        AddressArray addrArray = this.createAddressArray(this._config.getHomeDir(), this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.getIndexesCached());
        this._unitCapacity = 65536;
        LinearHashing h = new LinearHashing(this._unitCapacity);
        h.reinit(Integer.MAX_VALUE);
        this._maxLevel = h.getLevel();
        int initLevel = StoreParams.getDynamicStoreInitialLevel(this._config.getInitialCapacity());
        if (initLevel > this._maxLevel) {
            _log.warn((Object)("initLevel reset from " + initLevel + " to " + this._maxLevel));
            initLevel = this._maxLevel;
        }
        if (!found) {
            addrArray.expandCapacity((this._unitCapacity << initLevel) - 1);
            _log.info((Object)("capacity initialized to " + addrArray.length()));
        }
        String segmentHome = this._homeDir.getCanonicalPath() + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._scn = addrArray.getHWMark();
        this._dataArray = new SimpleDataArray(addrArray, segmentManager, this._config.getSegmentCompactFactor());
        this._hashFunction = this._config.getHashFunction();
        this._loadThreshold = this._config.getHashLoadFactor();
        this._loadCount = this.scan();
        this.initLinearHashing();
        _log.info((Object)this.getStatus());
    }

    public DynamicDataStore(File homeDir, int initLevel, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, 10000, 10, 256, segmentFactory, 0.5, 0.75, new FnvHashFunction());
    }

    public DynamicDataStore(File homeDir, int initLevel, SegmentFactory segmentFactory, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, initLevel, 10000, 10, 256, segmentFactory, 0.5, 0.75, hashFunction);
    }

    public DynamicDataStore(File homeDir, int initLevel, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, 10000, 10, segmentFileSizeMB, segmentFactory, 0.5, 0.75, new FnvHashFunction());
    }

    public DynamicDataStore(File homeDir, int initLevel, int segmentFileSizeMB, SegmentFactory segmentFactory, double hashLoadFactor, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, initLevel, 10000, 10, segmentFileSizeMB, segmentFactory, 0.5, hashLoadFactor, hashFunction);
    }

    public DynamicDataStore(File homeDir, int initLevel, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, 0.5, 0.75, new FnvHashFunction());
    }

    public DynamicDataStore(File homeDir, int initLevel, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double hashLoadFactor, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, initLevel, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, 0.5, hashLoadFactor, hashFunction);
    }

    public DynamicDataStore(File homeDir, int initLevel, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor, double hashLoadFactor, HashFunction<byte[]> hashFunction) throws Exception {
        LinearHashing h = new LinearHashing(65536);
        h.reinit(Integer.MAX_VALUE);
        this._maxLevel = h.getLevel();
        int initialCapacity = 65536;
        if (initLevel >= 0) {
            if (initLevel > this._maxLevel) {
                _log.warn((Object)("initLevel reset from " + initLevel + " to " + this._maxLevel));
                initLevel = this._maxLevel;
            }
            initialCapacity = 65536 << initLevel;
        } else {
            _log.warn((Object)("initLevel ignored: " + initLevel));
        }
        this._homeDir = homeDir;
        this._config = new StoreConfig(this._homeDir, initialCapacity);
        this._config.setBatchSize(batchSize);
        this._config.setNumSyncBatches(numSyncBatches);
        this._config.setSegmentFileSizeMB(segmentFileSizeMB);
        this._config.setSegmentCompactFactor(segmentCompactFactor);
        this._config.setSegmentFactory(segmentFactory);
        this._config.setHashLoadFactor(hashLoadFactor);
        this._config.setHashFunction(hashFunction);
        this._config.validate();
        this._config.save();
        this._dataHandler = new DefaultDataStoreHandler();
        boolean found = this.isAddressArrayFound(this._config.getHomeDir());
        AddressArray addrArray = this.createAddressArray(this._config.getHomeDir(), this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.getIndexesCached());
        if (!found) {
            addrArray.expandCapacity(initialCapacity - 1);
            _log.info((Object)("capacity initialized to " + addrArray.length()));
        }
        this._unitCapacity = 65536;
        String segmentHome = this._homeDir.getCanonicalPath() + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._scn = addrArray.getHWMark();
        this._dataArray = new SimpleDataArray(addrArray, segmentManager, this._config.getSegmentCompactFactor());
        this._hashFunction = hashFunction;
        this._loadThreshold = hashLoadFactor;
        this._loadCount = this.scan();
        this.initLinearHashing();
        _log.info((Object)this.getStatus());
    }

    protected boolean isAddressArrayFound(File homeDir) {
        File arrayFile = new File(homeDir, "indexes.dat");
        return arrayFile.exists();
    }

    protected AddressArray createAddressArray(File homeDir, int batchSize, int numSyncBatches, boolean indexesCached) throws Exception {
        AddressArrayFactory factory = new AddressArrayFactory(indexesCached);
        AddressArray addrArray = factory.createDynamicAddressArray(homeDir, batchSize, numSyncBatches);
        return addrArray;
    }

    protected long hash(byte[] key) {
        return this._hashFunction.hash(key);
    }

    protected long nextScn() {
        return ++this._scn;
    }

    @Override
    public final int capacity() {
        return this._dataArray.length();
    }

    @Override
    public int getLength(byte[] key) {
        byte[] value = this.get(key);
        return value == null ? -1 : value.length;
    }

    @Override
    public byte[] get(byte[] key) {
        byte[] existingData;
        long hashCode = this.hash(key);
        int index = this.getIndex(hashCode);
        while (true) {
            existingData = this._dataArray.get(index);
            int indexNew = this.getIndex(hashCode);
            if (index == indexNew) break;
            index = indexNew;
        }
        return existingData == null ? null : this._dataHandler.extractByKey(key, existingData);
    }

    @Override
    public synchronized boolean put(byte[] key, byte[] value) throws Exception {
        if (value == null) {
            return this.delete(key);
        }
        if (this.canSplit()) {
            this.split();
        }
        int index = this.getIndex(key);
        return this.putInternal(index, key, value);
    }

    @Override
    public synchronized boolean delete(byte[] key) throws Exception {
        if (this.canSplit()) {
            this.split();
        }
        int index = this.getIndex(key);
        return this.deleteInternal(index, key);
    }

    @Override
    public synchronized void sync() throws IOException {
        this._dataArray.sync();
    }

    @Override
    public synchronized void persist() throws IOException {
        this._dataArray.persist();
    }

    @Override
    public synchronized void clear() throws IOException {
        if (this._dataArray.isOpen()) {
            this._dataArray.clear();
            this._loadCount = 0;
        }
    }

    protected final int getIndex(byte[] key) {
        long capacity;
        long hashCode = this.hash(key);
        int index = (int)(hashCode % (capacity = (long)this._levelCapacity));
        if (index < 0) {
            index = -index;
        }
        if (index < this._split && (index = (int)(hashCode % (capacity <<= 1))) < 0) {
            index = -index;
        }
        return index;
    }

    protected final int getIndex(long hashCode) {
        long capacity = this._levelCapacity;
        int index = (int)(hashCode % capacity);
        if (index < 0) {
            index = -index;
        }
        if (index < this._split && (index = (int)(hashCode % (capacity <<= 1))) < 0) {
            index = -index;
        }
        return index;
    }

    protected boolean putInternal(int index, byte[] key, byte[] value) throws Exception {
        byte[] existingData = this._dataArray.get(index);
        if (existingData == null || existingData.length == 0) {
            this._dataArray.set(index, this._dataHandler.assemble(key, value), this.nextScn());
            ++this._loadCount;
        } else {
            try {
                this._dataArray.set(index, this._dataHandler.assemble(key, value, existingData), this.nextScn());
            }
            catch (Exception e) {
                _log.warn((Object)("Value reset at index=" + index + " key=\"" + new String(key) + "\""));
                this._dataArray.set(index, this._dataHandler.assemble(key, value), this.nextScn());
            }
        }
        return true;
    }

    protected boolean deleteInternal(int index, byte[] key) throws Exception {
        try {
            byte[] existingData = this._dataArray.get(index);
            if (existingData != null) {
                int newLength = this._dataHandler.removeByKey(key, existingData);
                if (newLength == 0) {
                    this._dataArray.set(index, null, this.nextScn());
                    --this._loadCount;
                    return true;
                }
                if (newLength < existingData.length) {
                    this._dataArray.set(index, existingData, 0, newLength, this.nextScn());
                    return true;
                }
            }
        }
        catch (Exception e) {
            _log.warn((Object)("Failed to delete key=\"" + new String(key) + "\" : " + e.getMessage()));
            this._dataArray.set(index, null, this.nextScn());
        }
        return false;
    }

    public final int getLevel() {
        return this._level;
    }

    public final int getSplit() {
        return this._split;
    }

    public final int getCapacity() {
        return this._dataArray.length();
    }

    public final int getUnitCapacity() {
        return this._unitCapacity;
    }

    public final int getLevelCapacity() {
        return this._levelCapacity;
    }

    public final int getLoadCount() {
        return this._loadCount;
    }

    public final double getLoadFactor() {
        return (double)this._loadCount / (double)this.capacity();
    }

    public final double getLoadThreshold() {
        return this._loadThreshold;
    }

    protected void initLinearHashing() throws Exception {
        int unitCount = this.capacity() / this.getUnitCapacity();
        if (unitCount <= 1) {
            this._level = 0;
            this._split = 0;
            this._levelCapacity = this.getUnitCapacity();
            this._loadCountThreshold = (int)((double)this.capacity() * this._loadThreshold);
        } else {
            this._level = 0;
            for (int remainder = unitCount - 1 >> 1; remainder > 0; remainder >>= 1) {
                ++this._level;
            }
            this._split = (unitCount - (1 << this._level) - 1) * this.getUnitCapacity();
            this._levelCapacity = this.getUnitCapacity() * (1 << this._level);
            this._loadCountThreshold = (int)((double)this.capacity() * this._loadThreshold);
            while (this.canSplitOnCapacity()) {
                this.split();
            }
        }
    }

    protected boolean canSplit() {
        int splitTo;
        return (0 < this._split || this._loadCountThreshold < this._loadCount) && Integer.MAX_VALUE > (splitTo = this._levelCapacity + this._split) && splitTo >= this._levelCapacity;
    }

    protected boolean canSplitOnCapacity() {
        if (0 < this._split) {
            int splitTo = this._levelCapacity + this._split;
            if (this.capacity() > splitTo && splitTo >= this._levelCapacity) {
                return true;
            }
        }
        return false;
    }

    protected void split() throws Exception {
        this._dataArray.getAddressArray().expandCapacity(this._split + this._levelCapacity);
        byte[] data = this._dataArray.get(this._split);
        if (data != null && data.length > 0) {
            List<Map.Entry<byte[], byte[]>> entries = this._dataHandler.extractEntries(data);
            ArrayList<Map.Entry<byte[], byte[]>> oldList = new ArrayList<Map.Entry<byte[], byte[]>>();
            ArrayList<Map.Entry<byte[], byte[]>> newList = new ArrayList<Map.Entry<byte[], byte[]>>();
            long newCapacity = (long)this._levelCapacity << 1;
            int toIndex = -1;
            for (Map.Entry<byte[], byte[]> e : entries) {
                byte[] key = e.getKey();
                int newIndex = (int)(this.hash(key) % newCapacity);
                if (newIndex < 0) {
                    newIndex = -newIndex;
                }
                if (newIndex == this._split) {
                    oldList.add(e);
                    continue;
                }
                newList.add(e);
                toIndex = newIndex;
            }
            if (entries.size() != oldList.size()) {
                byte[] newData = this._dataHandler.assembleEntries(newList);
                this._dataArray.getAddressArray().expandCapacity(toIndex);
                this._dataArray.set(toIndex, newData, this.nextScn());
                byte[] oldData = null;
                if (oldList.size() > 0) {
                    oldData = this._dataHandler.assembleEntries(oldList);
                }
                this._dataArray.set(this._split, oldData, this.nextScn());
                if (oldData != null) {
                    ++this._loadCount;
                }
            }
        }
        ++this._split;
        if (this._split % this._unitCapacity == 0) {
            _log.info((Object)("split-unit " + this.getStatus()));
        }
        if (this._split == this._levelCapacity) {
            int nextLevel = this._level + 1;
            int nextLevelCapacity = this.getUnitCapacity() * (1 << nextLevel);
            if (nextLevelCapacity > this._levelCapacity) {
                this._split = 0;
                this._level = nextLevel;
                this._levelCapacity = nextLevelCapacity;
                this._loadCountThreshold = (int)((double)this.capacity() * this._loadThreshold);
            }
            _log.info((Object)("split-done " + this.getStatus()));
        }
    }

    private int scan() {
        int cnt = 0;
        int len = this._dataArray.length();
        for (int i = 0; i < len; ++i) {
            if (!this._dataArray.hasData(i)) continue;
            ++cnt;
        }
        return cnt;
    }

    public synchronized void rehash() throws Exception {
        if (this.isOpen()) {
            while (this.canSplit()) {
                this.split();
            }
        } else {
            throw new StoreClosedException();
        }
        this._dataArray.sync();
    }

    public String getStatus() {
        StringBuilder buf = new StringBuilder();
        buf.append("mode=").append((Object)(this.isOpen() ? Mode.OPEN : Mode.CLOSED));
        buf.append(" level=").append(this._level);
        buf.append(" split=").append(this._split);
        buf.append(" capacity=").append(this.capacity());
        buf.append(" loadCount=").append(this._loadCount);
        buf.append(" loadFactor=").append(this.getLoadFactor());
        return buf.toString();
    }

    public final File getHomeDir() {
        return this._homeDir;
    }

    public final DataArray getDataArray() {
        return this._dataArray;
    }

    @Override
    public IndexedIterator<byte[]> keyIterator() {
        if (this.isOpen()) {
            return new DataStoreKeyIterator(this._dataArray, this._dataHandler);
        }
        throw new StoreClosedException();
    }

    @Override
    public IndexedIterator<Map.Entry<byte[], byte[]>> iterator() {
        if (this.isOpen()) {
            return new DataStoreIterator(this._dataArray, this._dataHandler);
        }
        throw new StoreClosedException();
    }

    @Override
    public boolean isOpen() {
        return this._dataArray.isOpen();
    }

    @Override
    public synchronized void open() throws IOException {
        if (!this._dataArray.isOpen()) {
            try {
                this._dataArray.open();
                this._loadCount = this.scan();
                this.initLinearHashing();
            }
            catch (Exception e) {
                try {
                    this._dataArray.close();
                }
                catch (Exception e2) {
                    _log.error((Object)"Failed to close", (Throwable)e2);
                }
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
            _log.info((Object)this.getStatus());
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._dataArray.isOpen()) {
            try {
                while (this.canSplitOnCapacity()) {
                    this.split();
                }
                this._dataArray.sync();
            }
            catch (Exception e) {
                _log.warn((Object)"linear hashing aborted", (Throwable)e);
            }
            this._dataArray.close();
            _log.info((Object)this.getStatus());
        }
    }

    public final PersistableListener getPersistableListener() {
        return this._dataArray.getPersistableListener();
    }

    public final void setPersistableListener(PersistableListener listener) {
        this._dataArray.setPersistableListener(listener);
    }
}

