/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import krati.PersistableListener;
import krati.core.StoreConfig;
import krati.core.StoreParams;
import krati.core.segment.MemorySegmentFactory;
import krati.core.segment.SegmentFactory;
import krati.store.BytesDB;
import krati.store.DataStore;
import krati.store.StoreClosedException;
import krati.store.index.HashIndex;
import krati.store.index.Index;
import krati.util.IndexedIterator;
import krati.util.Numbers;
import org.apache.log4j.Logger;

public class IndexedDataStore
implements DataStore<byte[], byte[]> {
    private static final Logger _logger = Logger.getLogger(IndexedDataStore.class);
    private final BytesDB _bytesDB;
    private final Index _index;
    private final File _homeDir;
    private final File _indexHome;
    private final File _storeHome;
    private long _scn;
    private volatile PersistableListener _listener = null;

    public IndexedDataStore(StoreConfig config) throws Exception {
        config.validate();
        config.save();
        this._homeDir = config.getHomeDir();
        this._storeHome = new File(this._homeDir, "store");
        int storeInitialCapacity = config.getInitialCapacity();
        StoreConfig storeConfig = new StoreConfig(this._storeHome, storeInitialCapacity);
        storeConfig.setIndexesCached(config.getIndexesCached());
        storeConfig.setBatchSize(config.getBatchSize());
        storeConfig.setNumSyncBatches(config.getNumSyncBatches());
        storeConfig.setSegmentFileSizeMB(config.getSegmentFileSizeMB());
        storeConfig.setSegmentFactory(config.getSegmentFactory());
        storeConfig.setSegmentCompactFactor(config.getSegmentCompactFactor());
        this._bytesDB = new BytesDB(storeConfig);
        this._scn = this._bytesDB.getHWMark();
        this._indexHome = new File(this._homeDir, "index");
        int indexInitialCapacity = config.getInt("krati.index.initial.capacity", config.getInitialCapacity());
        int indexSegmentFileSizeMB = config.getInt("krati.index.segment.file.size", 8);
        double indexSegmentCompactFactor = config.getDouble("krati.index.segment.compact.factor", config.getSegmentCompactFactor());
        SegmentFactory indexSegmentFactory = config.getClass("krati.index.segment.factory.class", MemorySegmentFactory.class).asSubclass(SegmentFactory.class).newInstance();
        StoreConfig indexConfig = new StoreConfig(this._indexHome, indexInitialCapacity);
        indexConfig.setBatchSize(config.getBatchSize());
        indexConfig.setNumSyncBatches(config.getNumSyncBatches());
        indexConfig.setIndexesCached(true);
        indexConfig.setSegmentFactory(indexSegmentFactory);
        indexConfig.setSegmentFileSizeMB(indexSegmentFileSizeMB);
        indexConfig.setSegmentCompactFactor(indexSegmentCompactFactor);
        indexConfig.setHashLoadFactor(config.getHashLoadFactor());
        indexConfig.setHashFunction(config.getHashFunction());
        indexConfig.setDataHandler(config.getDataHandler());
        this._index = new HashIndex(indexConfig);
        this.initIndexPersistableListener();
        _logger.info((Object)("opened indexHome=" + this._indexHome.getAbsolutePath() + " storeHome=" + this._storeHome.getAbsolutePath()));
    }

    public IndexedDataStore(File homeDir, int initialCapacity, int batchSize, int numSyncBatches, int indexSegmentFileSizeMB, SegmentFactory indexSegmentFactory, int storeSegmentFileSizeMB, SegmentFactory storeSegmentFactory) throws Exception {
        this._homeDir = homeDir;
        this._storeHome = new File(homeDir, "store");
        int storeInitialCapacity = initialCapacity;
        StoreConfig storeConfig = new StoreConfig(this._storeHome, storeInitialCapacity);
        storeConfig.setBatchSize(batchSize);
        storeConfig.setNumSyncBatches(numSyncBatches);
        storeConfig.setSegmentFileSizeMB(storeSegmentFileSizeMB);
        storeConfig.setSegmentFactory(storeSegmentFactory);
        this._bytesDB = new BytesDB(storeConfig);
        this._scn = this._bytesDB.getHWMark();
        this._indexHome = new File(homeDir, "index");
        int indexInitialCapacity = initialCapacity;
        StoreConfig indexConfig = new StoreConfig(this._indexHome, indexInitialCapacity);
        indexConfig.setBatchSize(batchSize);
        indexConfig.setNumSyncBatches(numSyncBatches);
        indexConfig.setSegmentFileSizeMB(indexSegmentFileSizeMB);
        indexConfig.setSegmentFactory(indexSegmentFactory);
        this._index = new HashIndex(indexConfig);
        this.initIndexPersistableListener();
        _logger.info((Object)("opened indexHome=" + this._indexHome.getAbsolutePath() + " storeHome=" + this._storeHome.getAbsolutePath()));
    }

    public IndexedDataStore(File homeDir, int batchSize, int numSyncBatches, int indexInitLevel, int indexSegmentFileSizeMB, SegmentFactory indexSegmentFactory, int storeInitLevel, int storeSegmentFileSizeMB, SegmentFactory storeSegmentFactory) throws Exception {
        this._homeDir = homeDir;
        this._storeHome = new File(homeDir, "store");
        int storeInitialCapacity = StoreParams.getDynamicStoreInitialCapacity(storeInitLevel);
        StoreConfig storeConfig = new StoreConfig(this._storeHome, storeInitialCapacity);
        storeConfig.setBatchSize(batchSize);
        storeConfig.setNumSyncBatches(numSyncBatches);
        storeConfig.setSegmentFileSizeMB(storeSegmentFileSizeMB);
        storeConfig.setSegmentFactory(storeSegmentFactory);
        this._bytesDB = new BytesDB(storeConfig);
        this._scn = this._bytesDB.getHWMark();
        this._indexHome = new File(homeDir, "index");
        int indexInitialCapacity = StoreParams.getDynamicStoreInitialCapacity(indexInitLevel);
        StoreConfig indexConfig = new StoreConfig(this._indexHome, indexInitialCapacity);
        indexConfig.setBatchSize(batchSize);
        indexConfig.setNumSyncBatches(numSyncBatches);
        indexConfig.setSegmentFileSizeMB(indexSegmentFileSizeMB);
        indexConfig.setSegmentFactory(indexSegmentFactory);
        this._index = new HashIndex(indexConfig);
        this.initIndexPersistableListener();
        _logger.info((Object)("opened indexHome=" + this._indexHome.getAbsolutePath() + " storeHome=" + this._storeHome.getAbsolutePath()));
    }

    protected void initIndexPersistableListener() {
        this._index.setPersistableListener(new PersistableListener(){

            @Override
            public void beforePersist() {
                try {
                    PersistableListener l = IndexedDataStore.this._listener;
                    if (l != null) {
                        l.beforePersist();
                    }
                }
                catch (Exception e) {
                    _logger.error((Object)"failed on calling beforePersist", (Throwable)e);
                }
                try {
                    IndexedDataStore.this._bytesDB.persist();
                }
                catch (Exception e) {
                    _logger.error((Object)"failed on calling beforePersist", (Throwable)e);
                }
            }

            @Override
            public void afterPersist() {
                try {
                    PersistableListener l = IndexedDataStore.this._listener;
                    if (l != null) {
                        l.afterPersist();
                    }
                }
                catch (Exception e) {
                    _logger.error((Object)"failed on calling afterPersist", (Throwable)e);
                }
            }
        });
    }

    protected long nextScn() {
        return ++this._scn;
    }

    public final File getHomeDir() {
        return this._homeDir;
    }

    public final File getIndexHome() {
        return this._indexHome;
    }

    public final File getStoreHome() {
        return this._storeHome;
    }

    @Override
    public final int capacity() {
        return this._index.capacity();
    }

    public final int getDBIndex(byte[] key) {
        if (key == null) {
            return -1;
        }
        byte[] metaBytes = this._index.lookup(key);
        if (metaBytes == null) {
            return -1;
        }
        IndexMeta meta = IndexMeta.parse(metaBytes);
        if (meta == null) {
            return -1;
        }
        return meta.getDataAddr();
    }

    @Override
    public int getLength(byte[] key) {
        if (key == null) {
            return -1;
        }
        byte[] metaBytes = this._index.lookup(key);
        if (metaBytes == null) {
            return -1;
        }
        IndexMeta meta = IndexMeta.parse(metaBytes);
        if (meta == null) {
            return -1;
        }
        return this._bytesDB.getLength(meta.getDataAddr());
    }

    @Override
    public byte[] get(byte[] key) {
        if (key == null) {
            return null;
        }
        byte[] metaBytes = this._index.lookup(key);
        if (metaBytes == null) {
            return null;
        }
        IndexMeta meta = IndexMeta.parse(metaBytes);
        if (meta == null) {
            return null;
        }
        return this._bytesDB.get(meta.getDataAddr());
    }

    @Override
    public synchronized boolean put(byte[] key, byte[] value) throws Exception {
        if (value == null) {
            return this.delete(key);
        }
        if (key == null) {
            return false;
        }
        IndexMeta meta = null;
        byte[] metaBytes = this._index.lookup(key);
        if (metaBytes != null) {
            meta = IndexMeta.parse(metaBytes);
        }
        if (meta == null) {
            int index = this._bytesDB.add(value, this.nextScn());
            metaBytes = IndexMeta.build(index);
            this._index.update(key, metaBytes);
        } else {
            int index = meta.getDataAddr();
            this._bytesDB.set(index, value, this.nextScn());
        }
        return true;
    }

    @Override
    public synchronized boolean delete(byte[] key) throws Exception {
        if (key == null) {
            return false;
        }
        byte[] metaBytes = this._index.lookup(key);
        if (metaBytes == null) {
            return false;
        }
        IndexMeta meta = IndexMeta.parse(metaBytes);
        if (meta == null) {
            return false;
        }
        this._bytesDB.set(meta.getDataAddr(), null, this.nextScn());
        this._index.update(key, null);
        return true;
    }

    @Override
    public synchronized void clear() throws IOException {
        this._bytesDB.clear();
        this._index.clear();
    }

    @Override
    public synchronized void persist() throws IOException {
        this._bytesDB.persist();
        this._index.persist();
    }

    @Override
    public synchronized void sync() throws IOException {
        this._bytesDB.sync();
        this._index.sync();
    }

    @Override
    public IndexedIterator<byte[]> keyIterator() {
        if (this.isOpen()) {
            return this._index.keyIterator();
        }
        throw new StoreClosedException();
    }

    @Override
    public IndexedIterator<Map.Entry<byte[], byte[]>> iterator() {
        if (this.isOpen()) {
            return new IndexedDataStoreIterator(this._index.iterator());
        }
        throw new StoreClosedException();
    }

    @Override
    public boolean isOpen() {
        return this._index.isOpen();
    }

    @Override
    public synchronized void open() throws IOException {
        try {
            this._bytesDB.open();
            this._index.open();
        }
        catch (IOException ioe) {
            this._index.close();
            this._bytesDB.close();
            throw ioe;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this._index.close();
            this._bytesDB.close();
        }
        catch (IOException ioe) {
            this._bytesDB.close();
            throw ioe;
        }
    }

    public final PersistableListener getPersistableListener() {
        return this._listener;
    }

    public final void setPersistableListener(PersistableListener listener) {
        this._listener = listener;
    }

    private class IndexedDataStoreIterator
    implements IndexedIterator<Map.Entry<byte[], byte[]>> {
        final IndexedIterator<Map.Entry<byte[], byte[]>> _indexIter;

        IndexedDataStoreIterator(IndexedIterator<Map.Entry<byte[], byte[]>> indexIter) {
            this._indexIter = indexIter;
        }

        @Override
        public boolean hasNext() {
            return this._indexIter.hasNext();
        }

        @Override
        public Map.Entry<byte[], byte[]> next() {
            Map.Entry keyMeta = (Map.Entry)this._indexIter.next();
            if (keyMeta != null) {
                IndexMeta meta = IndexMeta.parse((byte[])keyMeta.getValue());
                if (meta == null) {
                    return null;
                }
                byte[] value = IndexedDataStore.this._bytesDB.get(meta.getDataAddr());
                return new AbstractMap.SimpleEntry<byte[], byte[]>((byte[])keyMeta.getKey(), value);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int index() {
            return this._indexIter.index();
        }

        @Override
        public void reset(int indexStart) {
            this._indexIter.reset(indexStart);
        }
    }

    static class IndexMeta {
        final int _dataAddr;
        static final int META_SIZE = 4;

        IndexMeta(int dataAddr) {
            this._dataAddr = dataAddr;
        }

        static byte[] build(int dataAddr) {
            byte[] bytes = new byte[4];
            Numbers.intBytesBE(dataAddr, bytes);
            return bytes;
        }

        static IndexMeta parse(byte[] metaBytes) {
            if (metaBytes.length != 4) {
                return null;
            }
            int dataAddr = Numbers.intValueBE(metaBytes);
            return new IndexMeta(dataAddr);
        }

        int getDataAddr() {
            return this._dataAddr;
        }
    }
}

