/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.util.AbstractMap;
import java.util.Map;
import krati.io.Serializer;
import krati.store.ArrayStore;
import krati.util.IndexedIterator;

public class ObjectArrayIterator<V>
implements IndexedIterator<Map.Entry<Integer, V>> {
    private final ArrayStore _store;
    private final Serializer<V> _serializer;
    private int _index;

    public ObjectArrayIterator(ArrayStore store, Serializer<V> serializer) {
        this._store = store;
        this._serializer = serializer;
        this._index = store.getIndexStart();
    }

    @Override
    public int index() {
        return this._index;
    }

    @Override
    public void reset(int indexStart) {
        if (this._store.hasIndex(indexStart)) {
            this._index = indexStart;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(indexStart);
    }

    @Override
    public boolean hasNext() {
        return this._store.hasIndex(this._index);
    }

    @Override
    public Map.Entry<Integer, V> next() {
        byte[] bytes = this._store.get(this._index);
        Object value = bytes == null ? null : (Object)this._serializer.deserialize(bytes);
        AbstractMap.SimpleEntry<Integer, Object> ret = new AbstractMap.SimpleEntry<Integer, Object>(this._index, value);
        ++this._index;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

