/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.IOException;
import java.util.Map;
import krati.io.Serializer;
import krati.store.DataStore;
import krati.store.ObjectStore;
import krati.store.ObjectStoreIterator;
import krati.store.ObjectStoreKeyIterator;
import krati.store.StoreClosedException;
import krati.util.IndexedIterator;

public class SerializableObjectStore<K, V>
implements ObjectStore<K, V> {
    protected final DataStore<byte[], byte[]> _store;
    protected final Serializer<K> _keySerializer;
    protected final Serializer<V> _valSerializer;

    public SerializableObjectStore(DataStore<byte[], byte[]> store, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this._store = store;
        this._keySerializer = keySerializer;
        this._valSerializer = valueSerializer;
    }

    public final DataStore<byte[], byte[]> getStore() {
        return this._store;
    }

    public final Serializer<K> getKeySerializer() {
        return this._keySerializer;
    }

    public final Serializer<V> getValueSerializer() {
        return this._valSerializer;
    }

    @Override
    public final int capacity() {
        return this._store.capacity();
    }

    @Override
    public V get(K key) {
        if (key == null) {
            return null;
        }
        byte[] bytes = this._store.get(this._keySerializer.serialize(key));
        return bytes == null ? null : (V)this._valSerializer.deserialize(bytes);
    }

    @Override
    public int getLength(K key) {
        if (key == null) {
            return -1;
        }
        byte[] keyBytes = this._keySerializer.serialize(key);
        return this._store.getLength(keyBytes);
    }

    @Override
    public byte[] getBytes(K key) {
        if (key == null) {
            return null;
        }
        return this._store.get(this._keySerializer.serialize(key));
    }

    @Override
    public byte[] getBytes(byte[] keyBytes) {
        return this._store.get(keyBytes);
    }

    @Override
    public boolean put(K key, V value) throws Exception {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            return this._store.delete(this._keySerializer.serialize(key));
        }
        return this._store.put(this._keySerializer.serialize(key), this._valSerializer.serialize(value));
    }

    @Override
    public boolean delete(K key) throws Exception {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this._store.delete(this._keySerializer.serialize(key));
    }

    @Override
    public void sync() throws IOException {
        this._store.sync();
    }

    @Override
    public void persist() throws IOException {
        this._store.persist();
    }

    @Override
    public IndexedIterator<K> keyIterator() {
        if (this._store.isOpen()) {
            return new ObjectStoreKeyIterator<K>(this._store.keyIterator(), this._keySerializer);
        }
        throw new StoreClosedException();
    }

    @Override
    public IndexedIterator<Map.Entry<K, V>> iterator() {
        if (this._store.isOpen()) {
            return new ObjectStoreIterator<K, V>(this._store.iterator(), this._keySerializer, this._valSerializer);
        }
        throw new StoreClosedException();
    }

    @Override
    public boolean isOpen() {
        return this._store.isOpen();
    }

    @Override
    public void open() throws IOException {
        this._store.open();
    }

    @Override
    public void close() throws IOException {
        this._store.close();
    }

    @Override
    public void clear() throws IOException {
        this._store.clear();
    }
}

