/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import krati.PersistableListener;
import krati.array.Array;
import krati.core.StorePartitionConfig;
import krati.core.array.AddressArray;
import krati.core.array.AddressArrayFactory;
import krati.core.array.SimpleDataArray;
import krati.core.segment.MappedSegmentFactory;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;
import krati.store.ArrayStorePartition;
import org.apache.log4j.Logger;

public class StaticArrayStorePartition
implements ArrayStorePartition {
    private static final Logger _log = Logger.getLogger(StaticArrayStorePartition.class);
    private final StorePartitionConfig _config;
    private final SimpleDataArray _dataArray;
    private final int _idCount;
    private final int _idStart;
    private final int _idEnd;

    public StaticArrayStorePartition(StorePartitionConfig config) throws Exception {
        config.validate();
        config.save();
        this._config = config;
        this._idCount = config.getPartitionCount();
        this._idStart = config.getPartitionStart();
        this._idEnd = config.getPartitionEnd();
        AddressArray addressArray = this.createAddressArray(this._config.getHomeDir(), this._idCount, this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.isIndexesCached());
        String segmentHome = this._config.getHomeDir().getCanonicalPath() + File.separator + "segs";
        SegmentManager segManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._dataArray = new SimpleDataArray(addressArray, segManager, this._config.getSegmentCompactFactor());
        _log.info((Object)("init: " + this.getStatus()));
    }

    public StaticArrayStorePartition(int idStart, int idCount, File homeDir, int segmentFileSizeMB) throws Exception {
        this(idStart, idCount, homeDir, new MappedSegmentFactory(), segmentFileSizeMB);
    }

    public StaticArrayStorePartition(int idStart, int idCount, File homeDir, SegmentFactory segmentFactory, int segmentFileSizeMB) throws Exception {
        this(idStart, idCount, 10000, 10, homeDir, segmentFactory, segmentFileSizeMB, false);
    }

    public StaticArrayStorePartition(int idStart, int idCount, int batchSize, int numSyncBatches, File homeDir, SegmentFactory segmentFactory, int segmentFileSizeMB, boolean checked) throws Exception {
        this(idStart, idCount, batchSize, numSyncBatches, homeDir, segmentFactory, segmentFileSizeMB, 0.5, checked);
    }

    public StaticArrayStorePartition(int idStart, int idCount, int batchSize, int numSyncBatches, File homeDir, SegmentFactory segmentFactory, int segmentFileSizeMB, double segmentCompactFactor, boolean checked) throws Exception {
        this._config = new StorePartitionConfig(homeDir, idStart, idCount);
        this._config.setBatchSize(batchSize);
        this._config.setNumSyncBatches(numSyncBatches);
        this._config.setSegmentFactory(segmentFactory);
        this._config.setSegmentFileSizeMB(segmentFileSizeMB);
        this._config.setSegmentCompactFactor(segmentCompactFactor);
        this._config.validate();
        this._config.save();
        this._idStart = this._config.getPartitionStart();
        this._idCount = this._config.getPartitionCount();
        this._idEnd = this._config.getPartitionEnd();
        AddressArray addressArray = this.createAddressArray(this._config.getHomeDir(), this._idCount, this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.isIndexesCached());
        String segmentHome = this._config.getHomeDir().getCanonicalPath() + File.separator + "segs";
        SegmentManager segManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._dataArray = new SimpleDataArray(addressArray, segManager, this._config.getSegmentCompactFactor());
        if (checked) {
            // empty if block
        }
        _log.info((Object)("init: " + this.getStatus()));
    }

    protected AddressArray createAddressArray(File homeDir, int length, int batchSize, int numSyncBatches, boolean indexesCached) throws Exception {
        AddressArrayFactory factory = new AddressArrayFactory(indexesCached);
        AddressArray addrArray = factory.createStaticAddressArray(homeDir, length, batchSize, numSyncBatches);
        if (addrArray.length() != length) {
            throw new IOException("Capacity expected: " + addrArray.length() + " not " + length);
        }
        return addrArray;
    }

    protected String getStatus() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("idStart");
        buffer.append("=");
        buffer.append(this.getIdStart());
        buffer.append(" ");
        buffer.append("idCount");
        buffer.append("=");
        buffer.append(this.getIdCount());
        buffer.append(" ");
        buffer.append("lwMark");
        buffer.append("=");
        buffer.append(this.getLWMark());
        buffer.append(" ");
        buffer.append("hwMark");
        buffer.append("=");
        buffer.append(this.getHWMark());
        return buffer.toString();
    }

    private void rangeCheck(int memberId) {
        if (memberId < this._idStart || this._idEnd <= memberId) {
            throw new ArrayIndexOutOfBoundsException(memberId);
        }
    }

    public final File getHomeDir() {
        return this._config.getHomeDir();
    }

    @Override
    public int getIndexStart() {
        return this._idStart;
    }

    @Override
    public int capacity() {
        return this._idCount;
    }

    @Override
    public int getIdCount() {
        return this._idCount;
    }

    @Override
    public int getIdStart() {
        return this._idStart;
    }

    @Override
    public byte[] get(int index) {
        this.rangeCheck(index);
        return this._dataArray.get(index - this._idStart);
    }

    @Override
    public int get(int index, byte[] dst) {
        this.rangeCheck(index);
        return this._dataArray.get(index - this._idStart, dst);
    }

    @Override
    public int get(int index, byte[] dst, int offset) {
        this.rangeCheck(index);
        return this._dataArray.get(index - this._idStart, dst, offset);
    }

    @Override
    public synchronized void set(int index, byte[] data, long scn) throws Exception {
        this.rangeCheck(index);
        this._dataArray.set(index - this._idStart, data, scn);
    }

    @Override
    public synchronized void set(int index, byte[] data, int offset, int length, long scn) throws Exception {
        this.rangeCheck(index);
        this._dataArray.set(index - this._idStart, data, offset, length, scn);
    }

    @Override
    public synchronized void delete(int index, long scn) throws Exception {
        this.rangeCheck(index);
        this._dataArray.set(index - this._idStart, null, scn);
    }

    @Override
    public synchronized void sync() throws IOException {
        this._dataArray.sync();
        _log.info((Object)("sync: " + this.getStatus()));
    }

    @Override
    public synchronized void persist() throws IOException {
        this._dataArray.persist();
    }

    @Override
    public synchronized void clear() {
        this._dataArray.clear();
    }

    @Override
    public synchronized void saveHWMark(long endOfPeriod) throws Exception {
        this._dataArray.saveHWMark(endOfPeriod);
    }

    @Override
    public long getHWMark() {
        return this._dataArray.getHWMark();
    }

    @Override
    public long getLWMark() {
        return this._dataArray.getLWMark();
    }

    @Override
    public boolean hasIndex(int index) {
        return this._idStart <= index && index < this._idEnd;
    }

    @Override
    public int length() {
        return this._dataArray.length();
    }

    @Override
    public int getLength(int index) {
        this.rangeCheck(index);
        return this._dataArray.getLength(index - this._idStart);
    }

    @Override
    public boolean hasData(int index) {
        this.rangeCheck(index);
        return this._dataArray.hasData(index - this._idStart);
    }

    @Override
    public int transferTo(int index, WritableByteChannel channel) {
        this.rangeCheck(index);
        return this._dataArray.transferTo(index - this._idStart, channel);
    }

    @Override
    public boolean isOpen() {
        return this._dataArray.isOpen();
    }

    @Override
    public synchronized void open() throws IOException {
        this._dataArray.open();
    }

    @Override
    public synchronized void close() throws IOException {
        this._dataArray.close();
    }

    @Override
    public final Array.Type getType() {
        return Array.Type.STATIC;
    }

    public final PersistableListener getPersistableListener() {
        return this._dataArray.getPersistableListener();
    }

    public final void setPersistableListener(PersistableListener listener) {
        this._dataArray.setPersistableListener(listener);
    }
}

