/*
 * Decompiled with CFR 0.152.
 */
package krati.store.handler;

import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import krati.store.DataStoreHandler;
import krati.util.Bytes;
import krati.util.Conditions;
import org.apache.log4j.Logger;

public class FKFVDataStoreHandler
implements DataStoreHandler {
    private static final Logger _logger = Logger.getLogger(FKFVDataStoreHandler.class);
    private final int _keyLength;
    private final int _valLength;

    protected FKFVDataStoreHandler(int keyLength, int valueLength) {
        this._keyLength = keyLength;
        this._valLength = valueLength;
    }

    public final int getKeyLength() {
        return this._keyLength;
    }

    public final int getValueLength() {
        return this._valLength;
    }

    @Override
    public final byte[] assemble(byte[] key, byte[] value) {
        if (value == null) {
            return null;
        }
        Conditions.checkKeySize(key.length, this._keyLength);
        Conditions.checkValueSize(value.length, this._valLength);
        byte[] result = new byte[4 + this._keyLength + this._valLength];
        ByteBuffer bb = ByteBuffer.wrap(result);
        bb.putInt(1);
        bb.put(key);
        bb.put(value);
        return result;
    }

    @Override
    public final byte[] assemble(byte[] key, byte[] value, byte[] data) {
        if (data == null || data.length == 0) {
            return this.assemble(key, value);
        }
        Conditions.checkKeySize(key.length, this._keyLength);
        int newLength = this.removeByKey(key, data);
        if (newLength == 0) {
            return this.assemble(key, value);
        }
        if (value == null) {
            return Arrays.copyOf(data, newLength);
        }
        Conditions.checkValueSize(value.length, this._valLength);
        byte[] result = new byte[newLength + this._keyLength + this._valLength];
        System.arraycopy(data, 0, result, 0, newLength);
        ByteBuffer bb = ByteBuffer.wrap(result);
        int cnt = bb.getInt();
        bb.position(0);
        bb.putInt(cnt + 1);
        bb.position(newLength);
        bb.put(key);
        bb.put(value);
        return result;
    }

    @Override
    public final int countCollisions(byte[] key, byte[] data) {
        if (data == null || data.length == 0) {
            return 0;
        }
        try {
            int originalCnt;
            ByteBuffer bb = ByteBuffer.wrap(data);
            for (int cnt = originalCnt = bb.getInt(); cnt > 0; --cnt) {
                if (Bytes.equals(key, data, bb.position(), this._keyLength)) {
                    return originalCnt;
                }
                bb.position(bb.position() + this._keyLength + this._valLength);
            }
            return -originalCnt;
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to countCollisions", (Throwable)e);
            return 0;
        }
    }

    @Override
    public final byte[] extractByKey(byte[] key, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(data);
        for (int cnt = bb.getInt(); cnt > 0; --cnt) {
            if (Bytes.equals(key, data, bb.position(), this._keyLength)) {
                bb.position(bb.position() + this._keyLength);
                byte[] result = new byte[this._valLength];
                bb.get(result);
                return result;
            }
            bb.position(bb.position() + this._keyLength + this._valLength);
        }
        return null;
    }

    @Override
    public final int removeByKey(byte[] key, byte[] data) {
        int originalCnt;
        int offset1 = 0;
        int offset2 = 0;
        ByteBuffer bb = ByteBuffer.wrap(data);
        for (int cnt = originalCnt = bb.getInt(); cnt > 0; --cnt) {
            offset1 = bb.position();
            if (Bytes.equals(key, data, bb.position(), this._keyLength)) {
                bb.position(bb.position() + this._keyLength + this._valLength);
                offset2 = bb.position();
                break;
            }
            bb.position(bb.position() + this._keyLength + this._valLength);
        }
        if (offset1 < offset2) {
            int newLength = data.length - (offset2 - offset1);
            if (newLength <= 4) {
                return 0;
            }
            bb.position(0);
            bb.putInt(originalCnt - 1);
            int len = data.length - offset2;
            for (int i = 0; i < len; ++i) {
                data[offset1 + i] = data[offset2 + i];
            }
            return newLength;
        }
        return data.length;
    }

    @Override
    public final List<byte[]> extractKeys(byte[] data) {
        try {
            int cnt;
            ByteBuffer bb = ByteBuffer.wrap(data);
            ArrayList<byte[]> result = new ArrayList<byte[]>(cnt);
            for (cnt = bb.getInt(); cnt > 0; --cnt) {
                byte[] key = new byte[this._keyLength];
                bb.get(key);
                result.add(key);
                bb.position(bb.position() + this._valLength);
            }
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to extractKeys", (Throwable)e);
            return null;
        }
    }

    @Override
    public final List<byte[]> extractValues(byte[] data) {
        try {
            int cnt;
            ByteBuffer bb = ByteBuffer.wrap(data);
            ArrayList<byte[]> result = new ArrayList<byte[]>(cnt);
            for (cnt = bb.getInt(); cnt > 0; --cnt) {
                bb.position(bb.position() + this._keyLength);
                byte[] value = new byte[this._valLength];
                bb.get(value);
                result.add(value);
            }
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to extractValues", (Throwable)e);
            return null;
        }
    }

    @Override
    public final List<Map.Entry<byte[], byte[]>> extractEntries(byte[] data) {
        try {
            int cnt;
            ByteBuffer bb = ByteBuffer.wrap(data);
            ArrayList<Map.Entry<byte[], byte[]>> result = new ArrayList<Map.Entry<byte[], byte[]>>(cnt);
            for (cnt = bb.getInt(); cnt > 0; --cnt) {
                byte[] key = new byte[this._keyLength];
                bb.get(key);
                byte[] val = new byte[this._valLength];
                bb.get(val);
                result.add(new AbstractMap.SimpleEntry<byte[], byte[]>(key, val));
            }
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to extractEntries", (Throwable)e);
            return null;
        }
    }

    @Override
    public final byte[] assembleEntries(List<Map.Entry<byte[], byte[]>> entries) {
        byte[] b;
        int cnt = 0;
        int len = 4;
        for (Map.Entry<byte[], byte[]> e : entries) {
            b = e.getKey();
            if (b == null) continue;
            len += this._keyLength;
            len += this._valLength;
            ++cnt;
        }
        byte[] data = new byte[len];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt(cnt);
        for (Map.Entry<byte[], byte[]> e : entries) {
            b = e.getKey();
            if (b == null) continue;
            bb.put(b);
            b = e.getValue();
            bb.put(b);
        }
        return data;
    }
}

