/*
 * Decompiled with CFR 0.152.
 */
package krati.util;

import krati.store.InvalidDataException;

public class Conditions {
    public static void notNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
    }

    public static void checkSize(int size, int expected) {
        if (size != expected) {
            throw new InvalidDataException("Invalid size: " + size + " expected: " + expected);
        }
    }

    public static void checkKeySize(int keySize, int expected) {
        if (keySize != expected) {
            throw new InvalidDataException("Invalid key size: " + keySize + " expected: " + expected);
        }
    }

    public static void checkValueSize(int valueSize, int expected) {
        if (valueSize != expected) {
            throw new InvalidDataException("Invalid value size: " + valueSize + " expected: " + expected);
        }
    }

    public static void checkDataSize(int dataSize, int expected) {
        if (dataSize != expected) {
            throw new InvalidDataException("Invalid data size: " + dataSize + " expected: " + expected);
        }
    }

    public static void checkMaxSize(int size, int maxSize) {
        if (size < 0 || size > maxSize) {
            throw new InvalidDataException("Invalid size: " + size + " max: " + maxSize);
        }
    }

    public static void checkMaxKeySize(int keySize, int maxKeySize) {
        if (keySize < 0 || keySize > maxKeySize) {
            throw new InvalidDataException("Invalid key size: " + keySize + " max: " + maxKeySize);
        }
    }

    public static void checkMaxValueSize(int valueSize, int maxValueSize) {
        if (valueSize < 0 || valueSize > maxValueSize) {
            throw new InvalidDataException("Invalid value size: " + valueSize + " max: " + maxValueSize);
        }
    }

    public static void checkMaxDataSize(int dataSize, int maxDataSize) {
        if (dataSize < 0 || dataSize > maxDataSize) {
            throw new InvalidDataException("Invalid data size: " + dataSize + " max: " + maxDataSize);
        }
    }
}

