/*
 * Decompiled with CFR 0.152.
 */
package krati.util;

import java.io.Serializable;
import krati.util.Partition;

public class Range
implements Serializable,
Partition<Integer> {
    private static final long serialVersionUID = 1L;
    private final int start;
    private final int count;
    private final int end;

    public Range(int start, int count) {
        this.start = start;
        this.count = count;
        this.end = start + count;
    }

    public final boolean has(int num) {
        return this.start <= num && num < this.end;
    }

    public final int getCount() {
        return this.count;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public String toString() {
        StringBuilder b = new StringBuilder().append('[').append(this.start).append(',').append(this.end).append(')');
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Range range = (Range)obj;
        return this.start == range.start && this.start == range.count;
    }

    public int hashCode() {
        return this.start + this.count % 23;
    }

    @Override
    public boolean contains(Integer key) {
        return key == null ? false : this.has(key);
    }

    @Override
    public int capacity() {
        return this.count;
    }
}

