/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.krati;

import java.io.File;
import krati.core.StoreConfig;
import krati.core.segment.SegmentFactory;
import krati.io.Serializer;
import krati.store.DataSet;
import krati.store.DataStore;
import krati.store.DynamicDataSet;
import krati.store.DynamicDataStore;
import krati.store.SerializableObjectStore;
import krati.util.HashFunction;
import org.apache.camel.RuntimeCamelException;

public final class KratiHelper {
    private KratiHelper() {
    }

    public static <K, V> DataStore<K, V> createDataStore(String path, int initialCapacity, int segmentFileSize, SegmentFactory segmentFactory, HashFunction<byte[]> hashFunction, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        SerializableObjectStore<K, V> result = null;
        File homeDir = new File(path);
        homeDir.mkdirs();
        try {
            StoreConfig storeConfig = new StoreConfig(homeDir, initialCapacity);
            storeConfig.setSegmentFactory(segmentFactory);
            storeConfig.setHashFunction(hashFunction);
            storeConfig.setSegmentFileSizeMB(segmentFileSize);
            DynamicDataStore dynamicDataStore = new DynamicDataStore(storeConfig);
            result = new SerializableObjectStore<K, V>(dynamicDataStore, keySerializer, valueSerializer);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to create Krati DataStore.", (Throwable)e);
        }
        return result;
    }

    public static DataSet<byte[]> createDataSet(String path, int initialCapacity, SegmentFactory segmentFactory) {
        DynamicDataSet result = null;
        File homeDir = new File(path);
        homeDir.mkdirs();
        try {
            result = new DynamicDataSet(homeDir, initialCapacity, segmentFactory);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to create Krati DataSet. This exception is ignored.", (Throwable)e);
        }
        return result;
    }
}

