/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.pods;

import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.consumer.common.PodEvent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPodsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesPodsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private PodsConsumerTask podsWatcher;

    public KubernetesPodsConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.podsWatcher = new PodsConsumerTask();
        this.executor.submit(this.podsWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Pods Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                if (this.podsWatcher != null) {
                    this.podsWatcher.getWatch().close();
                }
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                if (this.podsWatcher != null) {
                    this.podsWatcher.getWatch().close();
                }
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class PodsConsumerTask
    implements Runnable {
        private Watch watch;

        PodsConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> w = KubernetesPodsConsumer.this.getEndpoint().getKubernetesClient().pods();
            if (ObjectHelper.isNotEmpty((Object)KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace())) {
                w.inNamespace(KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace());
            }
            if (ObjectHelper.isNotEmpty((Object)KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((Object)KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            if (ObjectHelper.isNotEmpty((Object)KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName())) {
                w.withName(KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName());
            }
            this.watch = (Watch)w.watch(new Watcher<Pod>(){

                @Override
                public void eventReceived(Watcher.Action action, Pod resource) {
                    PodEvent pe = new PodEvent(action, resource);
                    Exchange exchange = KubernetesPodsConsumer.this.getEndpoint().createExchange();
                    exchange.getIn().setBody((Object)pe.getPod());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)pe.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesPodsConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesPodsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                }

                @Override
                public void onClose(KubernetesClientException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

