/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.replication_controllers;

import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.consumer.common.ReplicationControllerEvent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesReplicationControllersConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesReplicationControllersConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private ReplicationControllersConsumerTask rcWatcher;

    public KubernetesReplicationControllersConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.rcWatcher = new ReplicationControllersConsumerTask();
        this.executor.submit(this.rcWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Replication Controllers Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                if (this.rcWatcher != null) {
                    this.rcWatcher.getWatch().close();
                }
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                if (this.rcWatcher != null) {
                    this.rcWatcher.getWatch().close();
                }
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ReplicationControllersConsumerTask
    implements Runnable {
        private Watch watch;

        ReplicationControllersConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> w = KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesClient().replicationControllers();
            if (ObjectHelper.isNotEmpty((Object)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace())) {
                w.inNamespace(KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace());
            }
            if (ObjectHelper.isNotEmpty((Object)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((Object)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            if (ObjectHelper.isNotEmpty((Object)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName())) {
                w.withName(KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName());
            }
            this.watch = (Watch)w.watch(new Watcher<ReplicationController>(){

                @Override
                public void eventReceived(Watcher.Action action, ReplicationController resource) {
                    ReplicationControllerEvent rce = new ReplicationControllerEvent(action, resource);
                    Exchange exchange = KubernetesReplicationControllersConsumer.this.getEndpoint().createExchange();
                    exchange.getIn().setBody((Object)rce.getReplicationController());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)rce.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesReplicationControllersConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesReplicationControllersConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                }

                @Override
                public void onClose(KubernetesClientException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

