/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.services;

import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.consumer.common.ServiceEvent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesServicesConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesServicesConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private ServicesConsumerTask servicesWatcher;

    public KubernetesServicesConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.servicesWatcher = new ServicesConsumerTask();
        this.executor.submit(this.servicesWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Services Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                if (this.servicesWatcher != null) {
                    this.servicesWatcher.getWatch().close();
                }
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                if (this.servicesWatcher != null) {
                    this.servicesWatcher.getWatch().close();
                }
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ServicesConsumerTask
    implements Runnable {
        private Watch watch;

        ServicesConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation<Service, ServiceList, DoneableService, ServiceResource<Service, DoneableService>> w = KubernetesServicesConsumer.this.getEndpoint().getKubernetesClient().services();
            if (ObjectHelper.isNotEmpty((Object)KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace())) {
                w.inNamespace(KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace());
            }
            if (ObjectHelper.isNotEmpty((Object)KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((Object)KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            if (ObjectHelper.isNotEmpty((Object)KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName())) {
                w.withName(KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName());
            }
            this.watch = (Watch)w.watch(new Watcher<Service>(){

                @Override
                public void eventReceived(Watcher.Action action, Service resource) {
                    ServiceEvent se = new ServiceEvent(action, resource);
                    Exchange exchange = KubernetesServicesConsumer.this.getEndpoint().createExchange();
                    exchange.getIn().setBody((Object)se.getService());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)se.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesServicesConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesServicesConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                }

                @Override
                public void onClose(KubernetesClientException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

