/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openshift.build_configs;

import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftBuildConfigsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftBuildConfigsProducer.class);

    public OpenshiftBuildConfigsProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listBuildConfigs": {
                this.doList(exchange, operation);
                break;
            }
            case "listBuildConfigsByLabels": {
                this.doListBuildConfigsByLabels(exchange, operation);
                break;
            }
            case "getBuildConfig": {
                this.doGetBuildConfig(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        BuildConfigList buildConfigsList = (BuildConfigList)((FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).buildConfigs().inAnyNamespace()).list();
        exchange.getOut().setBody(buildConfigsList.getItems());
    }

    protected void doListBuildConfigsByLabels(Exchange exchange, String operation) throws Exception {
        BuildConfigList buildConfigsList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesBuildConfigsLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            NonNamespaceOperation buildConfigs = (NonNamespaceOperation)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).buildConfigs().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                buildConfigs.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            buildConfigsList = (BuildConfigList)buildConfigs.list();
        } else {
            FilterWatchListMultiDeletable buildConfigs = (FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).buildConfigs().inAnyNamespace();
            for (Map.Entry entry : labels.entrySet()) {
                buildConfigs.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            buildConfigsList = (BuildConfigList)buildConfigs.list();
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody(buildConfigsList.getItems());
    }

    protected void doGetBuildConfig(Exchange exchange, String operation) throws Exception {
        BuildConfig buildConfig = null;
        String buildConfigName = (String)exchange.getIn().getHeader("CamelKubernetesBuildConfigName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)buildConfigName)) {
            LOG.error("Get a specific Build Config require specify a Build Config name");
            throw new IllegalArgumentException("Get a specific Build Config require specify a Build Config name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific Build Config require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Build Config require specify a namespace name");
        }
        buildConfig = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class).buildConfigs().inNamespace(namespaceName)).withName(buildConfigName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)buildConfig);
    }
}

