/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kudu;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kudu.KuduComponent;
import org.apache.camel.component.kudu.KuduConstants;
import org.apache.camel.component.kudu.KuduOperations;
import org.apache.camel.component.kudu.KuduProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.kudu.client.KuduClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.0", scheme="kudu", title="Kudu", syntax="kudu:host:port/tableName", category={Category.DATABASE, Category.IOT, Category.CLOUD}, producerOnly=true, headersClass=KuduConstants.class)
public class KuduEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(KuduEndpoint.class);
    private KuduClient kuduClient;
    @UriPath(name="host", displayName="Host", label="common", description="Host of the server to connect to")
    private String host;
    @UriPath(name="port", displayName="Port", label="common", description="Port of the server to connect to")
    private String port;
    @UriParam(description="Operation to perform")
    private KuduOperations operation;
    @UriPath(name="tableName", displayName="Table Name", label="common", description="Table to connect to")
    private String tableName;

    public KuduEndpoint(String uri, KuduComponent component) {
        super(uri, component);
        Pattern p = Pattern.compile("^(\\S+)\\:(\\d+)\\/(\\S+)$");
        Matcher m3 = p.matcher(uri);
        if (!m3.matches()) {
            throw new RuntimeException("Unrecognizable url: " + uri);
        }
        this.setHost(m3.group(1));
        this.setPort(m3.group(2));
        this.setTableName(m3.group(3));
    }

    @Override
    protected void doStart() throws Exception {
        LOG.trace("Connection: {}, {}", (Object)this.getHost(), (Object)this.getPort());
        if (this.getKuduClient() == null) {
            this.setKuduClient(new KuduClient.KuduClientBuilder(this.getHost() + ":" + this.getPort()).build());
        }
        LOG.debug("Resolved the host with the name {} as {}", (Object)this.getHost(), (Object)this.getKuduClient());
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        try {
            LOG.info("doStop()");
            this.getKuduClient().shutdown();
        }
        catch (Exception e) {
            LOG.error("Unable to shutdown kudu client", (Throwable)e);
        }
        super.doStop();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public KuduClient getKuduClient() {
        return this.kuduClient;
    }

    public void setKuduClient(KuduClient kuduClient) {
        this.kuduClient = kuduClient;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public Producer createProducer() {
        return new KuduProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("You cannot create consumers on this endpoint");
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public KuduOperations getOperation() {
        return this.operation;
    }

    public void setOperation(KuduOperations operation) {
        this.operation = operation;
    }
}

