/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.LineNumberAware;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.spi.ProcessorFactory;

public class TypedProcessorFactory<T extends NamedNode>
implements ProcessorFactory {
    private final Class<T> type;

    protected TypedProcessorFactory(Class<T> type) {
        this.type = type;
    }

    @Override
    public Processor createChildProcessor(Route route, NamedNode definition, boolean mandatory) throws Exception {
        if (this.type.isInstance(definition)) {
            Processor processor = this.doCreateChildProcessor(route, (NamedNode)this.type.cast(definition), mandatory);
            LineNumberAware.trySetLineNumberAware(processor, definition);
            return processor;
        }
        return null;
    }

    @Override
    public Processor createProcessor(Route route, NamedNode definition) throws Exception {
        if (this.type.isInstance(definition)) {
            Processor processor = this.doCreateProcessor(route, (NamedNode)this.type.cast(definition));
            LineNumberAware.trySetLineNumberAware(processor, definition);
            return processor;
        }
        return null;
    }

    @Override
    public Processor createProcessor(CamelContext camelContext, String definitionName, Object[] args) throws Exception {
        return null;
    }

    protected Processor doCreateChildProcessor(Route route, T definition, boolean mandatory) throws Exception {
        return null;
    }

    public Processor doCreateProcessor(Route route, T definition) throws Exception {
        return null;
    }
}

