/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsgiNamingHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiNamingHelper.class);

    private OsgiNamingHelper() {
    }

    public static String findFreeCamelContextName(BundleContext context, String prefix, String key, AtomicInteger counter, boolean checkFirst) {
        String candidate = null;
        boolean clash = false;
        block2: do {
            try {
                clash = false;
                candidate = candidate == null && checkFirst ? prefix : prefix + "-" + OsgiNamingHelper.getNextCounter(counter);
                LOG.trace("Checking OSGi Service Registry for existence of existing CamelContext with name: {}", (Object)candidate);
                ServiceReference<?>[] refs = context.getServiceReferences(CamelContext.class.getName(), "(" + key + "=" + candidate + ")");
                if (refs == null || refs.length <= 0) continue;
                for (ServiceReference<?> ref : refs) {
                    Object id = ref.getProperty(key);
                    if (id == null || !candidate.equals(id)) continue;
                    clash = true;
                    continue block2;
                }
            }
            catch (InvalidSyntaxException e) {
                LOG.debug("Error finding free Camel name in OSGi Service Registry due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
                break;
            }
        } while (clash);
        LOG.debug("Generated free name for bundle id: {}, clash: {} -> {}", new Object[]{context.getBundle().getBundleId(), clash, candidate});
        return candidate;
    }

    public static int getNextCounter(AtomicInteger counter) {
        return counter.incrementAndGet();
    }
}

